/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.structured.DocumentIdPrefix;
import org.apache.ctakes.typesystem.type.structured.DocumentPath;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class AbstractOutputFileWriter
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractOutputFileWriter");
    @ConfigurationParameter(name="OutputDirectory", description="Directory for all output files.")
    private File _outputRootDir;
    @ConfigurationParameter(name="SubDirectory", description="SubDirectory for files.", mandatory=false, defaultValue={""})
    private String _subDirectory;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this._subDirectory != null && !this._subDirectory.isEmpty()) {
            File subDirectory = new File(this._outputRootDir, this._subDirectory);
            if (!subDirectory.exists()) {
                subDirectory.mkdirs();
            }
        } else if (!this._outputRootDir.exists()) {
            this._outputRootDir.mkdirs();
        }
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        JCas jcas;
        try {
            jcas = cas.getJCas();
        }
        catch (CASException casE) {
            throw new AnalysisEngineProcessException((Throwable)casE);
        }
        String documentId = DocumentIDAnnotationUtil.getDocumentIdForFile(jcas);
        String outputDir = this.getOutputDirectory(jcas, this._outputRootDir.getPath(), documentId);
        String fileName = this.getSourceFileName(jcas, documentId);
        try {
            this.writeFile(jcas, outputDir, documentId, fileName);
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }

    public abstract void writeFile(JCas var1, String var2, String var3, String var4) throws IOException;

    protected String getOutputDirectory(JCas jcas, String rootPath, String documentId) {
        String subDirectory = this.getSubdirectory(jcas, documentId);
        if (subDirectory == null || subDirectory.isEmpty()) {
            return rootPath;
        }
        File outputDir = new File(rootPath + "/" + subDirectory);
        outputDir.mkdirs();
        return outputDir.getPath();
    }

    protected String getSubdirectory(JCas jCas, String documentId) {
        Collection prefices;
        String subDirectory = "";
        String subSeparator = "";
        if (this._subDirectory != null && !this._subDirectory.isEmpty()) {
            subDirectory = this._subDirectory;
            subSeparator = "/";
        }
        if ((prefices = JCasUtil.select((JCas)jCas, DocumentIdPrefix.class)) == null || prefices.isEmpty()) {
            LOGGER.debug((Object)("No subdirectory information for " + documentId));
            return subDirectory;
        }
        for (DocumentIdPrefix prefix : prefices) {
            String docSubDirectory = prefix.getDocumentIdPrefix();
            if (docSubDirectory == null || docSubDirectory.isEmpty()) continue;
            return subDirectory + subSeparator + docSubDirectory;
        }
        LOGGER.debug((Object)("No subdirectory information for " + documentId));
        return subDirectory;
    }

    protected String getSourceFilePath(JCas jCas) {
        Collection documentPaths = JCasUtil.select((JCas)jCas, DocumentPath.class);
        if (documentPaths == null || documentPaths.isEmpty()) {
            return "";
        }
        for (DocumentPath documentPath : documentPaths) {
            String path = documentPath.getDocumentPath();
            if (path == null || path.isEmpty()) continue;
            return path;
        }
        return "";
    }

    protected String getSourceFileName(JCas jcas, String documentId) {
        String path = this.getSourceFilePath(jcas);
        if (path != null && !path.isEmpty()) {
            return new File(path).getName();
        }
        return documentId;
    }
}

