/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

@PipeBitInfo(name="Token Offset Writer", description="Writes a two-column BSV file containing Begin and End offsets of tokens in a document.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.BASE_TOKEN})
public class TokenOffsetsCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    File iv_outputDirectory;

    public void initialize() throws ResourceInitializationException {
        String outputDirectoryName = (String)this.getConfigParameterValue(PARAM_OUTPUTDIR);
        this.iv_outputDirectory = new File(outputDirectoryName);
        if (!this.iv_outputDirectory.exists() || !this.iv_outputDirectory.isDirectory()) {
            throw new ResourceInitializationException((Throwable)new Exception("Parameter setting 'OutputDirectory' does not point to an existing directory."));
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            ArrayList<String> offsets = new ArrayList<String>();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            for (BaseToken token : indexes.getAnnotationIndex(BaseToken.type)) {
                String offset = "" + token.getBegin() + "|" + token.getEnd();
                offsets.add(offset);
            }
            String documentID = DocumentIDAnnotationUtil.getDocumentID(jcas);
            this.writeToFile(documentID, offsets);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    private void writeToFile(String documentID, List<String> offsets) throws IOException {
        File outputFile = new File(this.iv_outputDirectory, documentID);
        outputFile.createNewFile();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        for (int i = 0; i < offsets.size(); ++i) {
            String offset = offsets.get(i) + "\n";
            ((OutputStream)out).write(offset.getBytes());
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }
}

