/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty;

import java.util.Arrays;
import java.util.Collection;

public enum SemanticGroup {
    ANATOMICAL_SITE("Anatomy", "T021", "T022", "T023", "T024", "T025", "T026", "T029", "T030"),
    DISORDER("Disorder", "T019", "T020", "T037", "T047", "T048", "T049", "T050", "T190", "T191"),
    FINDING("Finding", "T033", "T034", "T040", "T041", "T042", "T043", "T044", "T045", "T046", "T056", "T057", "T184"),
    PROCEDURE("Procedure", "T059", "T060", "T061"),
    MEDICATION("Drug", "T109", "T110", "T114", "T115", "T116", "T118", "T119", "T121", "T122", "T123", "T124", "T125", "T126", "T127", "T129", "T130", "T131", "T195", "T196", "T197", "T200", "T203");

    private static final String UNKNOWN_SEMANTIC = "Unknown";
    private final String _name;
    private final Collection<String> _tuis;

    private SemanticGroup(String name, String ... tuis) {
        this._name = name;
        this._tuis = Arrays.asList(tuis);
    }

    public String getName() {
        return this._name;
    }

    public static String getSemanticName(String tui) {
        if (tui == null || tui.isEmpty()) {
            return UNKNOWN_SEMANTIC;
        }
        for (SemanticGroup semanticGroup : SemanticGroup.values()) {
            if (!semanticGroup._tuis.contains(tui)) continue;
            return semanticGroup._name;
        }
        return UNKNOWN_SEMANTIC;
    }
}

