/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cleartk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MaxContext
implements CleartkExtractor.Context {
    private CleartkExtractor.Context[] contexts;
    private String name;

    public MaxContext(CleartkExtractor.Context ... contexts) {
        this.contexts = contexts;
        String[] names = new String[contexts.length + 1];
        names[0] = "Max";
        for (int i = 1; i < names.length; ++i) {
            names[i] = contexts[i - 1].getName();
        }
        this.name = Feature.createName((String[])names);
    }

    public String getName() {
        return this.name;
    }

    public <SEARCH_T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, CleartkExtractor.Bounds bounds, Class<SEARCH_T> annotationClass, FeatureExtractor1<SEARCH_T> extractor) throws CleartkExtractorException {
        HashMap<String, Double> runningTotals = new HashMap<String, Double>();
        for (CleartkExtractor.Context context : this.contexts) {
            for (Feature feature : context.extract(jCas, focusAnnotation, bounds, annotationClass, extractor)) {
                try {
                    double val = Double.parseDouble(feature.getValue().toString());
                    if (!runningTotals.containsKey(feature.getName())) {
                        runningTotals.put(feature.getName(), 0.0);
                    }
                    runningTotals.put(feature.getName(), Double.max((Double)runningTotals.get(feature.getName()), val));
                }
                catch (Exception exception) {}
            }
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (String key : runningTotals.keySet()) {
            features.add(new Feature(this.name + "_" + key, runningTotals.get(key)));
        }
        return features;
    }
}

