/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import com.lexicalscope.jewel.cli.CliFactory;
import java.io.IOException;
import org.apache.ctakes.core.pipeline.CliOptionals;
import org.apache.ctakes.core.pipeline.PipelineBuilder;
import org.apache.ctakes.core.pipeline.PiperFileReader;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;

public final class PiperFileRunner {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperFileRunner");

    private PiperFileRunner() {
    }

    public static void main(String ... args) {
        CliOptionals options = (CliOptionals)CliFactory.parseArguments(CliOptionals.class, (String[])args);
        try {
            String umlsKey;
            String umlsPass;
            String umlsUser;
            PiperFileReader reader = new PiperFileReader();
            PipelineBuilder builder = reader.getBuilder();
            String inputDir = options.getInputDirectory();
            if (!inputDir.isEmpty()) {
                builder.set("InputDirectory", inputDir);
            }
            String outputDir = options.getOutputDirectory();
            String subDir = options.getSubDirectory();
            if (!subDir.isEmpty()) {
                builder.set("SubDirectory", subDir);
            }
            String xmiOutDir = options.getXmiOutDirectory();
            if (!outputDir.isEmpty()) {
                builder.set("OutputDirectory", outputDir);
            } else if (!xmiOutDir.isEmpty()) {
                builder.set("OutputDirectory", xmiOutDir);
            }
            String lookupXml = options.getLookupXml();
            if (!lookupXml.isEmpty()) {
                builder.set("LookupXml", lookupXml);
            }
            if (!(umlsUser = options.getUmlsUserName()).isEmpty()) {
                builder.set("umlsUser", umlsUser);
                builder.set("ctakes.umlsuser", umlsUser);
            }
            if (!(umlsPass = options.getUmlsPassword()).isEmpty()) {
                builder.set("umlsPass", umlsPass);
                builder.set("ctakes.umlspw", umlsPass);
            }
            if (!(umlsKey = options.getUmlsApiKey()).isEmpty()) {
                builder.set("umlsKey", umlsKey);
                builder.set("ctakes.umls_apikey", umlsKey);
            }
            reader.setCliOptionals(options);
            reader.loadPipelineFile(options.getPiperPath());
            if (!inputDir.isEmpty() && builder.getReader() == null) {
                builder.readFiles(inputDir);
            }
            if (!xmiOutDir.isEmpty() && !builder.getAeNames().stream().map(String::toLowerCase).anyMatch(n -> n.contains("xmiwriter"))) {
                builder.writeXMIs(xmiOutDir);
            }
            builder.run();
        }
        catch (IOException | UIMAException multE) {
            LOGGER.error((Object)multE.getMessage());
            System.exit(1);
        }
    }
}

