/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml;

import java.io.File;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.UimaContextFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.corpus.timeml.TempEval2007Writer;
import org.cleartk.opennlp.tools.ParserAnnotator;
import org.cleartk.opennlp.tools.PosTaggerAnnotator;
import org.cleartk.opennlp.tools.SentenceAnnotator;
import org.cleartk.snowball.DefaultSnowballStemmer;
import org.cleartk.timeml.event.EventAnnotator;
import org.cleartk.timeml.event.EventAspectAnnotator;
import org.cleartk.timeml.event.EventClassAnnotator;
import org.cleartk.timeml.event.EventModalityAnnotator;
import org.cleartk.timeml.event.EventPolarityAnnotator;
import org.cleartk.timeml.event.EventTenseAnnotator;
import org.cleartk.timeml.time.TimeAnnotator;
import org.cleartk.timeml.time.TimeTypeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToDocumentCreationTimeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSameSentenceTimeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSubordinatedEventAnnotator;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.token.tokenizer.TokenAnnotator;
import org.cleartk.util.cr.FilesCollectionReader;

public class TimeMlAnnotate {
    private static void error(String message) throws Exception {
        Logger logger = UimaContextFactory.createUimaContext((Object[])new Object[0]).getLogger();
        logger.log(Level.SEVERE, String.format("%s\nusage: java %s input-file-or-dir [output-dir]", TimeMlAnnotate.class.getName(), message));
        System.exit(1);
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 1 && args.length != 2) {
            TimeMlAnnotate.error("wrong number of arguments");
        } else if (!new File(args[0]).exists()) {
            TimeMlAnnotate.error("file or directory not found: " + args[0]);
        }
        String inputFileOrDir = args[0];
        File outputDir = new File(args.length == 2 ? args[1] : ".");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        SimplePipeline.runPipeline((CollectionReader)FilesCollectionReader.getCollectionReader((String)inputFileOrDir), (AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription(), TokenAnnotator.getDescription(), PosTaggerAnnotator.getDescription(), DefaultSnowballStemmer.getDescription((String)"English"), ParserAnnotator.getDescription(), TimeAnnotator.FACTORY.getAnnotatorDescription(), TimeTypeAnnotator.FACTORY.getAnnotatorDescription(), EventAnnotator.FACTORY.getAnnotatorDescription(), EventTenseAnnotator.FACTORY.getAnnotatorDescription(), EventAspectAnnotator.FACTORY.getAnnotatorDescription(), EventClassAnnotator.FACTORY.getAnnotatorDescription(), EventPolarityAnnotator.FACTORY.getAnnotatorDescription(), EventModalityAnnotator.FACTORY.getAnnotatorDescription(), AnalysisEngineFactory.createEngineDescription(AddEmptyDCT.class, (Object[])new Object[0]), TemporalLinkEventToDocumentCreationTimeAnnotator.FACTORY.getAnnotatorDescription(), TemporalLinkEventToSameSentenceTimeAnnotator.FACTORY.getAnnotatorDescription(), TemporalLinkEventToSubordinatedEventAnnotator.FACTORY.getAnnotatorDescription(), TempEval2007Writer.getDescription((String)outputDir.getPath())});
    }

    public static class AddEmptyDCT
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            DocumentCreationTime dct = new DocumentCreationTime(jCas, 0, 0);
            dct.setFunctionInDocument("CREATION_TIME");
            dct.setId("t0");
            dct.addToIndexes();
        }
    }
}

