/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.time;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkSequenceAnnotator;
import org.cleartk.ml.Instances;
import org.cleartk.ml.chunking.BioChunking;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.timeml.type.Time;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.TimeWordsExtractor;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class TimeAnnotator
extends CleartkSequenceAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TimeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(TimeAnnotator.class, (Object[])new Object[0]);
        }
    };
    private List<NamedFeatureExtractor1<Token>> tokenFeatureExtractors;
    private List<CleartkExtractor<Token, Token>> contextFeatureExtractors;
    private BioChunking<Token, Time> chunking;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.chunking = new BioChunking(Token.class, Time.class);
        this.tokenFeatureExtractors = Lists.newArrayList();
        this.tokenFeatureExtractors.add((NamedFeatureExtractor1<Token>)new CoveredTextExtractor());
        NamedFeatureExtractor1 ex = CharacterCategoryPatternFunction.createExtractor();
        this.tokenFeatureExtractors.add((NamedFeatureExtractor1<Token>)ex);
        this.tokenFeatureExtractors.add(new TimeWordsExtractor());
        this.tokenFeatureExtractors.add((NamedFeatureExtractor1<Token>)new TypePathExtractor(Token.class, "stem"));
        this.tokenFeatureExtractors.add((NamedFeatureExtractor1<Token>)new TypePathExtractor(Token.class, "pos"));
        this.contextFeatureExtractors = Lists.newArrayList();
        for (FeatureExtractor1 featureExtractor1 : this.tokenFeatureExtractors) {
            this.contextFeatureExtractors.add((CleartkExtractor<Token, Token>)new CleartkExtractor(Token.class, featureExtractor1, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)}));
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            ArrayList featureLists = new ArrayList();
            for (Token token : tokens) {
                ArrayList features = new ArrayList();
                for (FeatureExtractor1 featureExtractor1 : this.tokenFeatureExtractors) {
                    features.addAll(featureExtractor1.extract(jCas, (Annotation)token));
                }
                for (CleartkExtractor cleartkExtractor : this.contextFeatureExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                }
                featureLists.add(features);
            }
            if (this.isTraining()) {
                List times = JCasUtil.selectCovered((JCas)jCas, Time.class, (AnnotationFS)sentence);
                List outcomes = this.chunking.createOutcomes(jCas, tokens, times);
                this.dataWriter.write(Instances.toInstances((List)outcomes, featureLists));
                continue;
            }
            List outcomes = this.classifier.classify(featureLists);
            this.chunking.createChunks(jCas, tokens, outcomes);
        }
        int timeIndex = 1;
        for (Time time : JCasUtil.select((JCas)jCas, Time.class)) {
            if (time.getId() != null) continue;
            String id = String.format("t%d", timeIndex);
            time.setId(id);
            ++timeIndex;
        }
    }
}

