/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.coreference.ae.features.TokenFeatureExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class AttributeFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation ante, IdentifiedAnnotation ana) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        boolean anaNegated = TokenFeatureExtractor.isNegated(ana);
        features.add(new Feature("MC_ana_NEGATED", (Object)anaNegated));
        boolean anaUncertain = TokenFeatureExtractor.isUncertain(ana);
        features.add(new Feature("MC_ana_UNCERTAIN", (Object)anaUncertain));
        boolean anaGen = TokenFeatureExtractor.isGeneric(ana);
        features.add(new Feature("MC_ana_GENERIC", (Object)anaGen));
        boolean anaSubj = TokenFeatureExtractor.isPatient(ana);
        features.add(new Feature("MC_ana_PATIENT", (Object)anaSubj));
        boolean anaHist = TokenFeatureExtractor.isHistory(ana);
        features.add(new Feature("MC_ana_HISTORY", (Object)anaHist));
        boolean anaTimex = AttributeFeatureExtractor.isTimex((Annotation)ana);
        features.add(new Feature("MC_ana_TIMEX", (Object)anaTimex));
        boolean anteNegated = TokenFeatureExtractor.isNegated(ante);
        features.add(new Feature("MC_ante_NEGATED", (Object)anteNegated));
        boolean anteUncertain = TokenFeatureExtractor.isUncertain(ante);
        features.add(new Feature("MC_ante_UNCERTAIN", (Object)anteUncertain));
        boolean anteGen = TokenFeatureExtractor.isGeneric(ante);
        features.add(new Feature("MC_ante_GENERIC", (Object)anteGen));
        boolean anteSubj = TokenFeatureExtractor.isPatient(ante);
        features.add(new Feature("MC_ante_PATIENT", (Object)anteSubj));
        boolean anteHist = TokenFeatureExtractor.isHistory(ante);
        features.add(new Feature("MC_ante_HISTORY", (Object)anteHist));
        boolean anteTimex = AttributeFeatureExtractor.isTimex((Annotation)ante);
        features.add(new Feature("MC_ante_TIMEX", (Object)anteTimex));
        features.add(new Feature("MC_AGREE_NEG", (Object)(anteNegated == anaNegated ? 1 : 0)));
        features.add(new Feature("MC_AGREE_UNC", (Object)(anteUncertain == anaUncertain ? 1 : 0)));
        features.add(new Feature("MC_AGREE_TIMEX", (Object)(anteTimex == anaTimex ? 1 : 0)));
        return features;
    }

    private static boolean isTimex(Annotation a) {
        return JCasUtil.selectCovered(TimeMention.class, (AnnotationFS)a).size() > 0;
    }
}

