/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class TemporalFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        String a1dtr = TemporalFeatureExtractor.getDocTimeRelForArg(jCas, arg1);
        String a2dtr = TemporalFeatureExtractor.getDocTimeRelForArg(jCas, arg2);
        feats.add(new Feature("Arg1DTR_" + a1dtr, (Object)true));
        feats.add(new Feature("Arg2DTR_" + a2dtr, (Object)true));
        if (a1dtr.equals(a2dtr) && !a1dtr.equals("NA")) {
            feats.add(new Feature("DTR_Match", (Object)true));
        }
        return feats;
    }

    private static String getDocTimeRelForArg(JCas jCas, IdentifiedAnnotation arg) {
        String dtr = "NA";
        ConllDependencyNode node = DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg);
        if (node != null) {
            List events = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)node);
            for (EventMention event : events) {
                if (!event.getClass().getSimpleName().equals("EventMention") || event.getEvent() == null || event.getEvent().getProperties() == null || event.getEvent().getProperties().getDocTimeRel() == null) continue;
                dtr = event.getEvent().getProperties().getDocTimeRel();
            }
        }
        return dtr;
    }
}

