/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.util.ViewUriUtil;

public class UMLSFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    String docId = null;
    Map<ConllDependencyNode, Collection<IdentifiedAnnotation>> coveringMap = null;

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        if (this.docId == null || !UMLSFeatureExtractor.getDocId(jCas).equals(this.docId)) {
            this.docId = UMLSFeatureExtractor.getDocId(jCas);
            this.coveringMap = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        }
        if (arg1 instanceof Markable && arg2 instanceof Markable) {
            ConllDependencyNode head1 = DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg1);
            ConllDependencyNode head2 = DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg2);
            ArrayList<IdentifiedAnnotation> rmList = new ArrayList<IdentifiedAnnotation>();
            if (head1 != null && head2 != null) {
                ArrayList<IdentifiedAnnotation> ents1 = new ArrayList<IdentifiedAnnotation>(this.coveringMap.get(head1));
                for (IdentifiedAnnotation ann : ents1) {
                    if ((ann instanceof EntityMention || ann instanceof EventMention) && ann.getClass() != EventMention.class) continue;
                    rmList.add(ann);
                }
                for (IdentifiedAnnotation toRm : rmList) {
                    ents1.remove(toRm);
                }
                rmList.clear();
                ArrayList<IdentifiedAnnotation> ents2 = new ArrayList<IdentifiedAnnotation>(this.coveringMap.get(head2));
                for (IdentifiedAnnotation ann : ents2) {
                    if ((ann instanceof EntityMention || ann instanceof EventMention) && ann.getClass() != EventMention.class) continue;
                    rmList.add(ann);
                }
                for (IdentifiedAnnotation toRm : rmList) {
                    ents2.remove(toRm);
                }
                if (ents1.size() == 0 && ents2.size() > 0) {
                    feats.add(new Feature("Arg1NoCui_Arg2Cui", (Object)true));
                } else if (ents1.size() > 0 && ents2.size() == 0) {
                    feats.add(new Feature("Arg1Cui_Arg2NoCui", (Object)true));
                } else if (ents1.size() == 0 && ents2.size() == 0) {
                    feats.add(new Feature("Arg1Arg2NoCui", (Object)true));
                } else {
                    feats.add(new Feature("Arg1Arg2BothCui", (Object)true));
                }
                if (ents1.size() == 0 & ents2.size() > 0 || ents1.size() > 0 && ents2.size() == 0) {
                    feats.add(new Feature("Arg1OrArg2NoCui", (Object)true));
                }
                for (IdentifiedAnnotation ent1 : ents1) {
                    HashSet<String> a1Tuis = new HashSet<String>();
                    String a1SemType = ent1.getClass().getSimpleName();
                    feats.add(new Feature("Arg1SemType" + a1SemType, (Object)true));
                    FSArray cons1 = ent1.getOntologyConceptArr();
                    if (cons1 != null) {
                        for (int i = 0; i < cons1.size(); ++i) {
                            if (!(cons1.get(i) instanceof UmlsConcept)) continue;
                            a1Tuis.add(((UmlsConcept)cons1.get(i)).getTui());
                        }
                    }
                    for (IdentifiedAnnotation ent2 : ents2) {
                        HashSet<String> a2Tuis = new HashSet<String>();
                        String a2SemType = ent2.getClass().getSimpleName();
                        feats.add(new Feature("Arg2SemType" + a2SemType, (Object)true));
                        if (UMLSFeatureExtractor.alias(ent1, ent2)) {
                            feats.add(new Feature("UMLS_ALIAS", (Object)true));
                        }
                        feats.add(new Feature("Arg1Arg2SemType" + a1SemType + "_" + a2SemType, (Object)true));
                        FSArray cons2 = ent2.getOntologyConceptArr();
                        if (cons2 != null) {
                            for (int i = 0; i < cons2.size(); ++i) {
                                if (!(cons2.get(i) instanceof UmlsConcept)) continue;
                                a2Tuis.add(((UmlsConcept)cons2.get(i)).getTui());
                            }
                        }
                        for (String tui1 : a1Tuis) {
                            feats.add(new Feature("Arg1Tui_" + tui1, (Object)true));
                            for (String tui2 : a2Tuis) {
                                feats.add(new Feature("Arg1Tui_" + tui1 + "_Arg2Tui_ " + tui2, (Object)true));
                                if (!tui1.equals(tui2)) continue;
                                feats.add(new Feature("Arg1Arg2TuiMatch", (Object)true));
                            }
                        }
                        for (String tui2 : a2Tuis) {
                            feats.add(new Feature("Arg2Tui_" + tui2, (Object)true));
                        }
                    }
                }
            }
        }
        return feats;
    }

    public static String getDocId(JCas jcas) {
        String docId = null;
        docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        if (docId != "UnknownDocument") {
            return docId;
        }
        try {
            if (jcas.getView("UriView") != null) {
                docId = ViewUriUtil.getURI((JCas)jcas).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return docId;
    }

    public static boolean alias(IdentifiedAnnotation a1, IdentifiedAnnotation a2) {
        if (a1 != null && a2 != null) {
            for (UmlsConcept concept1 : JCasUtil.select((FSArray)a1.getOntologyConceptArr(), UmlsConcept.class)) {
                String cui = concept1.getCui();
                for (UmlsConcept concept2 : JCasUtil.select((FSArray)a2.getOntologyConceptArr(), UmlsConcept.class)) {
                    if (!cui.equals(concept2.getCui())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

