/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.coreference.ae.features.TokenFeatureExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MentionClusterAttributeFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>,
FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        Markable member;
        ArrayList<Feature> features = new ArrayList<Feature>();
        boolean mentionNegated = TokenFeatureExtractor.isNegated(mention);
        boolean mentionUnc = TokenFeatureExtractor.isUncertain(mention);
        boolean mentionTimex = MentionClusterAttributeFeaturesExtractor.isTimex((Annotation)mention);
        boolean matchNeg = true;
        boolean clusterTimex = false;
        boolean matchUnc = true;
        Iterator iterator = JCasUtil.select((FSList)cluster.getMembers(), Markable.class).iterator();
        while (iterator.hasNext() && (member = (Markable)iterator.next()).getBegin() <= mention.getEnd()) {
            if (mentionNegated != TokenFeatureExtractor.isNegated((IdentifiedAnnotation)member)) {
                matchNeg = false;
            }
            if (mentionUnc != TokenFeatureExtractor.isUncertain((IdentifiedAnnotation)member)) {
                matchUnc = false;
            }
            if (!MentionClusterAttributeFeaturesExtractor.isTimex((Annotation)member)) continue;
            clusterTimex = true;
        }
        features.add(new Feature("MC_AGREE_NEG", (Object)matchNeg));
        features.add(new Feature("MC_AGREE_UNC", (Object)matchUnc));
        features.add(new Feature("MC_AGREE_TIMEX", (Object)(clusterTimex == mentionTimex ? 1 : 0)));
        return features;
    }

    public List<Feature> extract(JCas view, Markable mention) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        boolean mentionNegated = TokenFeatureExtractor.isNegated((IdentifiedAnnotation)mention);
        features.add(new Feature("MC_MENTION_NEGATED", (Object)mentionNegated));
        boolean mentionUncertain = TokenFeatureExtractor.isUncertain((IdentifiedAnnotation)mention);
        features.add(new Feature("MC_MENTION_UNCERTAIN", (Object)mentionUncertain));
        boolean mentionGen = TokenFeatureExtractor.isGeneric((IdentifiedAnnotation)mention);
        features.add(new Feature("MC_MENTION_GENERIC", (Object)mentionGen));
        boolean mentionSubj = TokenFeatureExtractor.isPatient((IdentifiedAnnotation)mention);
        features.add(new Feature("MC_MENTION_PATIENT", (Object)mentionSubj));
        boolean mentionHist = TokenFeatureExtractor.isHistory((IdentifiedAnnotation)mention);
        features.add(new Feature("MC_MENTION_HISTORY", (Object)mentionHist));
        boolean mentionTimex = MentionClusterAttributeFeaturesExtractor.isTimex((Annotation)mention);
        features.add(new Feature("MC_MENTION_TIMEX", (Object)mentionTimex));
        return features;
    }

    private static boolean isTimex(Annotation a) {
        return JCasUtil.selectCovered(TimeMention.class, (AnnotationFS)a).size() > 0;
    }

    private static LocationOfTextRelation getLocation(IdentifiedAnnotation annot) {
        LocationOfTextRelation rel = null;
        if (annot instanceof ProcedureMention) {
            rel = ((ProcedureMention)annot).getBodyLocation();
        } else if (annot instanceof DiseaseDisorderMention) {
            rel = ((DiseaseDisorderMention)annot).getBodyLocation();
        } else if (annot instanceof SignSymptomMention) {
            rel = ((SignSymptomMention)annot).getBodyLocation();
        }
        return rel;
    }
}

