/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.coreference.util.ClusterUtils;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class MentionClusterStackFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        NonEmptyFSList members = (NonEmptyFSList)cluster.getMembers();
        Annotation mostRecent = ClusterUtils.getMostRecent(members, (Annotation)mention);
        int mentionEnd = mostRecent.getEnd();
        int numIntervening = 0;
        int numNonSingletonIntervening = 0;
        for (CollectionTextRelation otherCluster : JCasUtil.select((JCas)jCas, CollectionTextRelation.class)) {
            if (otherCluster == cluster || (mostRecent = ClusterUtils.getMostRecent(members = (NonEmptyFSList)otherCluster.getMembers(), (Annotation)mention)) == null || mostRecent.getEnd() <= mentionEnd) continue;
            ++numIntervening;
            if (ClusterUtils.getSize(members) <= 1) continue;
            ++numNonSingletonIntervening;
        }
        feats.add(new Feature("ClusterStackPositionInclSingleton", (Object)(1.0 + Math.log10(numIntervening + 1))));
        feats.add(new Feature("ClusterStackPosition", (Object)(1.0 + Math.log10(numNonSingletonIntervening + 1))));
        return feats;
    }
}

