/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.salience;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class GrammaticalRoleFeatureExtractor
implements FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jcas, Markable markable) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ConllDependencyNode head = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)markable);
        if (head == null) {
            return feats;
        }
        Sentence sent = DependencyUtility.getSentence((JCas)jcas, (Annotation)markable);
        List sentNodes = DependencyUtility.getDependencyNodes((JCas)jcas, (Annotation)sent);
        int numNodes = sentNodes.size() - 1;
        feats.add(new Feature("GrammaticalRoleSentencePositionFirst", (Object)(head.getId() == 1 ? 1 : 0)));
        feats.add(new Feature("GrammaticalRoleSentencePositionLast", (Object)(head.getId() == numNodes ? 1 : 0)));
        if (head.getId() < numNodes / 3) {
            feats.add(new Feature("GrammaticalRoleSentencePositionBegin", (Object)true));
        } else if (head.getId() > 2 * (numNodes / 3)) {
            feats.add(new Feature("GrammaticalRoleSentencePositionEnd", (Object)true));
        } else {
            feats.add(new Feature("GrammaticalRoleSentencePositionMiddle", (Object)true));
        }
        String deprel = head.getDeprel();
        if (deprel.equals("nsubj")) {
            feats.add(new Feature("GrammaticalRoleRelSubj", (Object)true));
        } else if (deprel.equals("dobj") || deprel.equals("iobj")) {
            feats.add(new Feature("GrammaticalRoleRelVerbArg", (Object)true));
        } else if (deprel.equals("nn")) {
            feats.add(new Feature("GrammaticalRoleRelNounArg", (Object)true));
        } else if (deprel.equals("root")) {
            feats.add(new Feature("GrammaticalRoleRelRoot", (Object)true));
        } else if (deprel.equals("conj")) {
            feats.add(new Feature("GrammaticalRoleRelConj", (Object)true));
        } else {
            feats.add(new Feature("GrammaticalRoleRelOther", (Object)true));
        }
        return feats;
    }
}

