/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.salience;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MorphosyntacticFeatureExtractor
implements FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jcas, Markable markable) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ConllDependencyNode head = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)markable);
        if (head == null) {
            return feats;
        }
        List covering = DependencyUtility.getProgeny((ConllDependencyNode)head, (List)DependencyUtility.getDependencyNodes((JCas)jcas, (Annotation)DependencyUtility.getSentence((JCas)jcas, (Annotation)markable)));
        if (head.getId() != 0 && (head.getPostag().startsWith("PRP") || head.getPostag().equals("DT") && !head.getDeprel().equals("det"))) {
            feats.add(new Feature("MorphoIsPronoun", (Object)true));
        } else {
            feats.add(new Feature("MorphoIsPronoun", (Object)false));
        }
        feats.add(new Feature("MorphoIsProper", (Object)head.getPostag().equals("NNP")));
        feats.add(new Feature("MorphoPlural", (Object)head.getPostag().equals("NNS")));
        boolean indefinite = false;
        boolean containsNum = false;
        for (ConllDependencyNode node : covering) {
            if (node.getPostag().equals("DT") && (node.getLemma().equals("a") || node.getLemma().equals("an"))) {
                indefinite = true;
            }
            if (!node.getPostag().equals("CD")) continue;
            containsNum = true;
        }
        feats.add(new Feature("MorphoIndefinite", (Object)indefinite));
        feats.add(new Feature("MorphoNumeric", (Object)containsNum));
        feats.add(new Feature("MorphoNumModifiers", (Object)(covering.size() - 1)));
        return feats;
    }
}

