/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.pairing.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.coreference.ae.MentionClusterCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.pairing.AnnotationPairer;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.utils.struct.MapFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public abstract class ClusterMentionPairer_ImplBase
implements AnnotationPairer<Markable, MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair> {
    private Map<ConllDependencyNode, Collection<IdentifiedAnnotation>> nodeEntMap = null;

    @Override
    public abstract List<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair> getPairs(JCas var1, Markable var2);

    @Override
    public void reset(JCas jcas) {
        this.nodeEntMap = JCasUtil.indexCovering((JCas)jcas, ConllDependencyNode.class, IdentifiedAnnotation.class);
    }

    public Set<String> getBestEnt(JCas jcas, CollectionTextRelation cluster) {
        HashSet<String> semTypes = new HashSet<String>();
        for (Markable member : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
            semTypes.addAll(this.getBestEnt(jcas, member));
        }
        return semTypes;
    }

    public Set<String> getBestEnt(JCas jcas, Markable markable) {
        HashSet<String> bestEnts = new HashSet<String>();
        Object bestEnt = null;
        HashSet<IdentifiedAnnotation> otherBestEnts = new HashSet<IdentifiedAnnotation>();
        ConllDependencyNode head = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jcas), (TOP)markable);
        if (head == null) {
            return Collections.emptySet();
        }
        Collection<IdentifiedAnnotation> coveringEnts = this.nodeEntMap.get(head);
        for (IdentifiedAnnotation ent : coveringEnts) {
            ConllDependencyNode entHead;
            if (ent.getOntologyConceptArr() == null || (entHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jcas), (TOP)ent)) != head) continue;
            if (bestEnt == null) {
                bestEnt = ent;
                continue;
            }
            if (ent.getEnd() - ent.getBegin() > bestEnt.getEnd() - bestEnt.getBegin()) {
                bestEnt = ent;
                otherBestEnts = new HashSet();
                continue;
            }
            if (ent.getEnd() - ent.getBegin() != bestEnt.getEnd() - bestEnt.getBegin()) continue;
            otherBestEnts.add(ent);
        }
        if (bestEnt != null) {
            bestEnts.add(bestEnt.getClass().getSimpleName());
            for (IdentifiedAnnotation other : otherBestEnts) {
                bestEnts.add(other.getClass().getSimpleName());
            }
        }
        return bestEnts;
    }

    protected static final boolean dominates(Annotation arg1, Annotation arg2) {
        return arg1.getBegin() <= arg2.getBegin() && arg1.getEnd() >= arg2.getEnd();
    }
}

