/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.pairing.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.coreference.ae.EventCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.MentionClusterCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.pairing.cluster.ClusterMentionPairer_ImplBase;
import org.apache.ctakes.coreference.util.ClusterUtils;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.MedicationEventMention;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;

public class SentenceDistancePairer
extends ClusterMentionPairer_ImplBase {
    private int sentDistance;

    public SentenceDistancePairer(int distance) {
        this.sentDistance = distance;
    }

    @Override
    public List<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair> getPairs(JCas jcas, Markable mention) {
        ArrayList<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair>();
        Set<String> bestAnaTypes = this.getBestEnt(jcas, mention);
        for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
            IdentifiedAnnotation mostRecent;
            NonEmptyFSList members = (NonEmptyFSList)cluster.getMembers();
            Annotation first = (Annotation)members.getHead();
            if (first == null || mention.getBegin() <= first.getEnd() || !bestAnaTypes.contains(AnatomicalSiteMention.class.getSimpleName()) && !bestAnaTypes.contains(MedicationEventMention.class.getSimpleName()) && ((mostRecent = (IdentifiedAnnotation)ClusterUtils.getMostRecent(members, (Annotation)mention)) == null || EventCoreferenceAnnotator.sentDist(jcas, mostRecent, (IdentifiedAnnotation)mention) > this.sentDistance)) continue;
            Set<String> bestClusterTypes = this.getBestEnt(jcas, cluster);
            if (bestAnaTypes.size() > 0 && bestClusterTypes.size() > 0) {
                boolean overlap = false;
                for (String semType : bestAnaTypes) {
                    if (!bestClusterTypes.contains(semType)) continue;
                    overlap = true;
                }
                if (!overlap) continue;
            }
            pairs.add(new MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair(cluster, (IdentifiedAnnotation)mention));
        }
        return pairs;
    }
}

