/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

public class EditDistance {
    public static int distance(String s1, String s2) {
        return (int)EditDistance.distance(s1, s2, false);
    }

    public static double normalizedDistance(String s1, String s2) {
        return EditDistance.distance(s1, s2, true);
    }

    public static double distance(String s1, String s2, boolean normalize) {
        int i;
        String ls1 = s1.toLowerCase();
        String ls2 = s2.toLowerCase();
        int l1 = s1.length();
        int l2 = s2.length();
        int[][] dist = new int[l1 + 1][l2 + 1];
        byte[][] track = new byte[l1 + 1][l2 + 1];
        dist[0][0] = 0;
        track[0][0] = 0;
        for (i = 1; i <= l1; ++i) {
            dist[i][0] = i;
            track[i][0] = 100;
        }
        for (i = 1; i <= l2; ++i) {
            dist[0][i] = i;
            track[0][i] = 105;
        }
        for (i = 1; i <= l1; ++i) {
            for (int j = 1; j <= l2; ++j) {
                int c;
                int b;
                int d1 = dist[i][j - 1] + 1;
                int d2 = dist[i - 1][j] + 1;
                if (ls1.charAt(i - 1) == ls2.charAt(j - 1)) {
                    b = 109;
                    c = 0;
                } else {
                    b = 115;
                    c = 1;
                }
                int d3 = dist[i - 1][j - 1] + c;
                if (d1 <= d2 && d1 <= d3) {
                    dist[i][j] = d1;
                    track[i][j] = 105;
                    continue;
                }
                if (d2 <= d1 && d2 <= d3) {
                    dist[i][j] = d2;
                    track[i][j] = 100;
                    continue;
                }
                if (d3 > d1 || d3 > d2) continue;
                dist[i][j] = d3;
                track[i][j] = b;
            }
        }
        return normalize ? (double)dist[l1][l2] / (double)(l1 > l2 ? l1 : l2) : (double)dist[l1][l2];
    }
}

