/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icefaces.impl.util.Util;
import org.icefaces.util.EnvUtils;

public class CompatResourceServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(CompatResourceServlet.class.getName());
    private static final String BASE_PATH = "com/icesoft/faces/resources";
    private ClassLoader loader;
    private final Date lastModified = new Date();
    private final String STARTUP_TIME = Util.HTTP_DATE.format(this.lastModified);
    private ServletContext servletContext;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.loader = ((Object)((Object)this)).getClass().getClassLoader();
        this.servletContext = servletConfig.getServletContext();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean acceptGzip;
        String modifedHeader = httpServletRequest.getHeader("If-Modified-Since");
        if (null != modifedHeader) {
            try {
                Date modifiedSince = Util.HTTP_DATE.parse(modifedHeader);
                if (modifiedSince.getTime() + 1000L > this.lastModified.getTime()) {
                    httpServletResponse.setStatus(304);
                    httpServletResponse.setDateHeader("Date", new Date().getTime());
                    httpServletResponse.setDateHeader("Last-Modified", this.lastModified.getTime());
                    return;
                }
            }
            catch (ParseException e) {
                log.log(Level.FINE, "failed to parse date: " + modifedHeader, e);
            }
            catch (NumberFormatException e) {
                log.log(Level.FINE, "failed to parse date: " + modifedHeader, e);
            }
        }
        String path = httpServletRequest.getPathInfo();
        InputStream in = this.loader.getResourceAsStream(BASE_PATH + path);
        if (null == in) {
            httpServletResponse.setStatus(404, "Resource not found");
            return;
        }
        String mimeType = this.servletContext.getMimeType(path);
        if ("/blank".equalsIgnoreCase(path)) {
            mimeType = "text/html";
        }
        httpServletResponse.setHeader("Content-Type", mimeType);
        httpServletResponse.setHeader("Last-Modified", this.STARTUP_TIME);
        ServletOutputStream out = httpServletResponse.getOutputStream();
        boolean compressResources = !"false".equalsIgnoreCase(this.servletContext.getInitParameter(EnvUtils.COMPRESS_RESOURCES));
        String acceptHeader = httpServletRequest.getHeader("Accept-Encoding");
        boolean bl = acceptGzip = null != acceptHeader && acceptHeader.indexOf("gzip") >= 0;
        if (acceptGzip && compressResources && Util.shouldCompress((String)mimeType)) {
            httpServletResponse.setHeader("Content-Encoding", "gzip");
            Util.compressStream((InputStream)in, (OutputStream)out);
        } else {
            Util.copyStream((InputStream)in, (OutputStream)out);
        }
    }
}

