/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.resource.LuceneIndexReaderResource;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.BaseLookupConsumerImpl;
import org.apache.ctakes.dictionary.lookup.ae.LookupConsumer;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.temporary.assertion.AssertionCuePhraseAnnotation;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class AssertionCuePhraseConsumerImpl
extends BaseLookupConsumerImpl
implements LookupConsumer {
    public static final String CUE_PHRASE_FIELD_NAME = "cuePhrase";
    public static final String CUE_PHRASE_CATEGORY_FIELD_NAME = "cuePhraseCategory";
    public static final String CUE_PHRASE_FAMILY_FIELD_NAME = "cuePhraseFamily";
    public static final String CUE_PHRASE_FIRST_WORD_FIELD_NAME = "cuePhraseFirstWord";
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private final String CODE_MF_PRP_KEY = "codeMetaField";
    private final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private final String LUCENE_FILTER_RESRC_KEY_PRP_KEY = "luceneFilterExtResrcKey";
    private Properties iv_props;
    private IndexSearcher iv_searcher;
    private int iv_maxHits;

    public AssertionCuePhraseConsumerImpl(UimaContext aCtx, Properties props, int maxListSize) throws Exception {
        this.iv_props = props;
        this.iv_maxHits = maxListSize;
        String resrcName = this.iv_props.getProperty("luceneFilterExtResrcKey");
        LuceneIndexReaderResource resrc = (LuceneIndexReaderResource)aCtx.getResourceObject(resrcName);
        this.iv_searcher = new IndexSearcher(resrc.getIndexReader());
    }

    public AssertionCuePhraseConsumerImpl(UimaContext aCtx, Properties props) throws Exception {
        this.iv_props = props;
        String resrcName = this.iv_props.getProperty("luceneFilterExtResrcKey");
        LuceneIndexReaderResource resrc = (LuceneIndexReaderResource)aCtx.getResourceObject(resrcName);
        this.iv_searcher = new IndexSearcher(resrc.getIndexReader());
        this.iv_maxHits = Integer.MAX_VALUE;
    }

    public void consumeHits(JCas jcas, Iterator lhItr) throws AnalysisEngineProcessException {
        Iterator<Set<LookupHit>> hitsByOffsetItr = AssertionCuePhraseConsumerImpl.organizeByOffset(lhItr);
        while (hitsByOffsetItr.hasNext()) {
            Collection hitsAtOffsetCol = hitsByOffsetItr.next();
            Iterator lhAtOffsetItr = hitsAtOffsetCol.iterator();
            int neBegin = -1;
            int neEnd = -1;
            HashSet validCodeCol = new HashSet();
            while (lhAtOffsetItr.hasNext()) {
                LookupHit lh = (LookupHit)lhAtOffsetItr.next();
                neBegin = lh.getStartOffset();
                neEnd = lh.getEndOffset();
                String text = jcas.getDocumentText().substring(lh.getStartOffset(), lh.getEndOffset());
                text = text.trim().toLowerCase();
                MetaDataHit mdh = lh.getDictMetaDataHit();
                String cuePhrase = mdh.getMetaFieldValue(CUE_PHRASE_FIELD_NAME);
                String cuePhraseFirstWord = mdh.getMetaFieldValue(CUE_PHRASE_FIRST_WORD_FIELD_NAME);
                String cuePhraseCategory = mdh.getMetaFieldValue(CUE_PHRASE_CATEGORY_FIELD_NAME);
                String cuePhraseFamily = mdh.getMetaFieldValue(CUE_PHRASE_FAMILY_FIELD_NAME);
                AssertionCuePhraseAnnotation cuePhraseAnnotation = new AssertionCuePhraseAnnotation(jcas);
                cuePhraseAnnotation.setBegin(neBegin);
                cuePhraseAnnotation.setEnd(neEnd);
                cuePhraseAnnotation.setCuePhrase(cuePhrase);
                cuePhraseAnnotation.setCuePhraseFirstWord(cuePhraseFirstWord);
                cuePhraseAnnotation.setCuePhraseCategory(cuePhraseCategory);
                cuePhraseAnnotation.setCuePhraseAssertionFamily(cuePhraseFamily);
                cuePhraseAnnotation.addToIndexes();
            }
        }
    }

    private FSArray createOntologyConceptArr(JCas jcas, Collection validCodeCol) {
        FSArray ocArr = new FSArray(jcas, validCodeCol.size());
        int ocArrIdx = 0;
        for (String validCode : validCodeCol) {
            OntologyConcept oc = new OntologyConcept(jcas);
            oc.setCode(validCode);
            oc.setCodingScheme(this.iv_props.getProperty("codingScheme"));
            ocArr.set(ocArrIdx, (FeatureStructure)oc);
            ++ocArrIdx;
        }
        return ocArr;
    }

    private boolean isValid(String fieldName, String str) throws AnalysisEngineProcessException {
        try {
            TermQuery q = new TermQuery(new Term(fieldName, str));
            TopDocs topDoc = this.iv_searcher.search((Query)q, this.iv_maxHits);
            ScoreDoc[] hits = topDoc.scoreDocs;
            return hits != null && hits.length > 0;
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

