/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.BaseLookupConsumerImpl;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.LabMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class NamedEntityLookupConsumerImpl
extends BaseLookupConsumerImpl {
    private static final String CODE_MF_PRP_KEY = "codeMetaField";
    private static final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private static final String TYPE_ID_FIELD = "typeIdField";
    private final Properties _properties;
    private static int iv_maxSize;

    public NamedEntityLookupConsumerImpl(UimaContext aCtx, Properties props, int maxListSize) {
        this._properties = props;
        iv_maxSize = maxListSize;
    }

    public NamedEntityLookupConsumerImpl(UimaContext aCtx, Properties props) {
        this._properties = props;
    }

    private int countUniqueCodes(Collection<LookupHit> hitsAtOffset) {
        String CODE_MF = this._properties.getProperty(CODE_MF_PRP_KEY);
        HashSet<String> codes = new HashSet<String>();
        for (LookupHit lookupHit : hitsAtOffset) {
            MetaDataHit mdh = lookupHit.getDictMetaDataHit();
            String code = mdh.getMetaFieldValue(CODE_MF);
            codes.add(code);
        }
        return codes.size();
    }

    @Override
    public void consumeHits(JCas jcas, Iterator<LookupHit> lhItr) throws AnalysisEngineProcessException {
        String TYPE_ID = this._properties.getProperty(TYPE_ID_FIELD);
        String CODE_MF = this._properties.getProperty(CODE_MF_PRP_KEY);
        String CODING_SCHEME = this._properties.getProperty(CODING_SCHEME_PRP_KEY);
        int typeId = 0;
        if (TYPE_ID != null) {
            try {
                typeId = Integer.parseInt(TYPE_ID);
            }
            catch (NumberFormatException nfe) {
                typeId = 0;
            }
        }
        Map<BaseLookupConsumerImpl.LookupHitKey, Set<LookupHit>> lookupHitMap = NamedEntityLookupConsumerImpl.createLookupHitMap(lhItr);
        for (Map.Entry<BaseLookupConsumerImpl.LookupHitKey, Set<LookupHit>> entry : lookupHitMap.entrySet()) {
            int uniqueCodeCount = this.countUniqueCodes((Collection<LookupHit>)entry.getValue());
            FSArray ocArr = new FSArray(jcas, uniqueCodeCount);
            int ocArrIdx = 0;
            HashSet<String> codes = new HashSet<String>();
            for (LookupHit lookupHit : entry.getValue()) {
                MetaDataHit mdh = lookupHit.getDictMetaDataHit();
                String code = mdh.getMetaFieldValue(CODE_MF);
                if (codes.contains(code)) continue;
                OntologyConcept oc = new OntologyConcept(jcas);
                oc.setCode(code);
                oc.setCodingScheme(CODING_SCHEME);
                ocArr.set(ocArrIdx, (FeatureStructure)oc);
                ++ocArrIdx;
                codes.add(code);
            }
            Object neAnnot = new IdentifiedAnnotation(jcas);
            neAnnot = typeId == 1 ? new MedicationMention(jcas) : (typeId == 6 ? new AnatomicalSiteMention(jcas) : (typeId == 2 ? new DiseaseDisorderMention(jcas) : (typeId == 3 ? new SignSymptomMention(jcas) : (typeId == 9 ? new LabMention(jcas) : (typeId == 5 ? new ProcedureMention(jcas) : new EntityMention(jcas))))));
            int neBegin = entry.getKey().__start;
            int neEnd = entry.getKey().__end;
            neAnnot.setBegin(neBegin);
            neAnnot.setEnd(neEnd);
            neAnnot.setDiscoveryTechnique(1);
            neAnnot.setOntologyConceptArr(ocArr);
            neAnnot.setTypeID(typeId);
            neAnnot.addToIndexes();
        }
    }
}

