/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.filter;

import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.DictionaryException;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.filter.FilterException;
import org.apache.ctakes.dictionary.lookup.filter.PostLookupFilter;

public class MetaDataPostLookupFilterImpl
implements PostLookupFilter {
    private String[] iv_metaFieldNames;
    private DictionaryEngine iv_dictEngine;
    private boolean iv_excludeMatches = false;

    public MetaDataPostLookupFilterImpl(DictionaryEngine dictEngine, String[] metaFieldNames, boolean excludeMatches) {
        this.iv_dictEngine = dictEngine;
        this.iv_metaFieldNames = metaFieldNames;
        this.iv_excludeMatches = excludeMatches;
    }

    @Override
    public boolean contains(MetaDataHit mdh) throws FilterException {
        String mdVal = this.getMetaDataValue(mdh);
        try {
            boolean isContained = this.iv_dictEngine.binaryLookup(mdVal);
            if (this.iv_excludeMatches) {
                return isContained;
            }
            return !isContained;
        }
        catch (DictionaryException ge) {
            throw new FilterException(ge);
        }
    }

    private String getMetaDataValue(MetaDataHit mdh) throws FilterException {
        for (int i = 0; i < this.iv_metaFieldNames.length; ++i) {
            String mdVal = mdh.getMetaFieldValue(this.iv_metaFieldNames[i]);
            if (mdVal == null) continue;
            return mdVal;
        }
        throw new FilterException(new Exception("Unable to extract meta data from MetaDataHit object."));
    }
}

