/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.strtable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.ctakes.dictionary.lookup.AbstractBaseDictionary;
import org.apache.ctakes.dictionary.lookup.DictionaryException;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.strtable.StringTable;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableRow;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableRowMetaDataHitImpl;

public class StringTableDictionaryImpl
extends AbstractBaseDictionary {
    private final StringTable iv_strTable;
    private final String iv_lookupFieldName;

    public StringTableDictionaryImpl(StringTable strTable, String lookupFieldName) {
        this.iv_strTable = strTable;
        this.iv_lookupFieldName = lookupFieldName;
    }

    @Override
    public boolean contains(String text) throws DictionaryException {
        return this.iv_strTable.getRows(this.iv_lookupFieldName, text).length > 0;
    }

    @Override
    public Collection<MetaDataHit> getEntries(String text) throws DictionaryException {
        StringTableRow[] strTableRows = this.iv_strTable.getRows(this.iv_lookupFieldName, text);
        if (strTableRows.length == 0) {
            return Collections.emptySet();
        }
        HashSet<MetaDataHit> metaDataHitSet = new HashSet<MetaDataHit>();
        for (StringTableRow tableRow : strTableRows) {
            StringTableRowMetaDataHitImpl metaDataHit = new StringTableRowMetaDataHitImpl(tableRow);
            metaDataHitSet.add(metaDataHit);
        }
        return metaDataHitSet;
    }
}

