/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final HttpChannel<?> _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private Async _async;
    private boolean _initial;
    private boolean _asyncRead;
    private boolean _asyncWrite;
    private long _timeoutMs = 30000L;
    private AsyncContextEvent _event;

    protected HttpChannelState(HttpChannel<?> channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._async = null;
        this._initial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long ms) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._timeoutMs = ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._timeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncContextEvent getAsyncContextEvent() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return String.format("%s@%x{s=%s i=%b a=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._initial, this._async});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return String.format("s=%s i=%b a=%s", new Object[]{this._state, this._initial, this._async});
        }
    }

    protected Action handling() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this.DEBUG) {
                LOG.debug("{} handling {}", new Object[]{this, this._state});
            }
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    return Action.REQUEST_DISPATCH;
                }
                case COMPLETING: {
                    return Action.COMPLETE;
                }
                case COMPLETED: {
                    return Action.WAIT;
                }
                case ASYNCWAIT: {
                    if (this._asyncRead) {
                        this._state = State.ASYNCIO;
                        this._asyncRead = false;
                        return Action.READ_CALLBACK;
                    }
                    if (this._asyncWrite) {
                        this._state = State.ASYNCIO;
                        this._asyncWrite = false;
                        return Action.WRITE_CALLBACK;
                    }
                    if (this._async != null) {
                        Async async = this._async;
                        switch (async) {
                            case COMPLETE: {
                                this._state = State.COMPLETING;
                                return Action.COMPLETE;
                            }
                            case DISPATCH: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                return Action.ASYNC_DISPATCH;
                            }
                            case EXPIRING: {
                                break;
                            }
                            case EXPIRED: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                return Action.ASYNC_EXPIRED;
                            }
                            case STARTED: {
                                if (this.DEBUG) {
                                    LOG.debug("TODO Fix this double dispatch", new IllegalStateException(this.getStatusString()));
                                }
                                return Action.WAIT;
                            }
                        }
                    }
                    return Action.WAIT;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsync(AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._state != State.DISPATCHED || this._async != null) {
                throw new IllegalStateException(this.getStatusString());
            }
            this._async = Async.STARTED;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            for (AsyncListener listener : lastAsyncListeners) {
                try {
                    listener.onStartAsync(event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Throwable th) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._event != null) {
                this._event.setThrowable(th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Action unhandle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this.DEBUG) {
                LOG.debug("{} unhandle {}", new Object[]{this, this._state});
            }
            switch (this._state) {
                case DISPATCHED: 
                case ASYNCIO: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            if (this._asyncRead) {
                this._state = State.ASYNCIO;
                this._asyncRead = false;
                return Action.READ_CALLBACK;
            }
            if (this._asyncWrite) {
                this._asyncWrite = false;
                this._state = State.ASYNCIO;
                return Action.WRITE_CALLBACK;
            }
            if (this._async != null) {
                this._initial = false;
                switch (this._async) {
                    case COMPLETE: {
                        this._state = State.COMPLETING;
                        this._async = null;
                        return Action.COMPLETE;
                    }
                    case DISPATCH: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        return Action.ASYNC_DISPATCH;
                    }
                    case EXPIRED: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        return Action.ASYNC_EXPIRED;
                    }
                    case EXPIRING: 
                    case STARTED: {
                        this.scheduleTimeout();
                        this._state = State.ASYNCWAIT;
                        return Action.WAIT;
                    }
                }
            }
            this._state = State.COMPLETING;
            return Action.COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(ServletContext context, String path) {
        boolean dispatch;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._async != Async.STARTED && this._async != Async.EXPIRING) {
                throw new IllegalStateException("AsyncContext#dispath " + this.getStatusString());
            }
            this._async = Async.DISPATCH;
            this._event.setDispatchTarget(context, path);
            switch (this._state) {
                case DISPATCHED: 
                case ASYNCIO: {
                    dispatch = false;
                    break;
                }
                default: {
                    dispatch = true;
                }
            }
        }
        this.cancelTimeout();
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        List<AsyncListener> aListeners;
        AsyncContextEvent event;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._async != Async.STARTED) {
                return;
            }
            this._async = Async.EXPIRING;
            event = this._event;
            aListeners = this._asyncListeners;
        }
        if (aListeners != null) {
            for (AsyncListener listener : aListeners) {
                try {
                    listener.onTimeout(event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
        boolean dispatch = false;
        HttpChannelState httpChannelState2 = this;
        synchronized (httpChannelState2) {
            if (this._async == Async.EXPIRING) {
                this._async = Async.EXPIRED;
                if (this._state == State.ASYNCWAIT) {
                    dispatch = true;
                }
            }
        }
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean handle;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._async != Async.STARTED && this._async != Async.EXPIRING) {
                throw new IllegalStateException(this.getStatusString());
            }
            this._async = Async.COMPLETE;
            handle = this._state == State.ASYNCWAIT;
        }
        this.cancelTimeout();
        if (handle) {
            ContextHandler handler = this.getContextHandler();
            if (handler != null) {
                handler.handle(this._channel);
            } else {
                this._channel.handle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed() {
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETING: {
                    this._state = State.COMPLETED;
                    aListeners = this._asyncListeners;
                    event = this._event;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (event != null) {
            if (aListeners != null) {
                if (event.getThrowable() != null) {
                    event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", event.getThrowable());
                    event.getSuppliedRequest().setAttribute("javax.servlet.error.message", event.getThrowable().getMessage());
                }
                for (AsyncListener listener : aListeners) {
                    try {
                        if (event.getThrowable() != null) {
                            listener.onError(event);
                            continue;
                        }
                        listener.onComplete(event);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                }
            }
            event.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case ASYNCIO: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._async = null;
            this._initial = true;
            this._asyncRead = false;
            this._asyncWrite = false;
            this._timeoutMs = 30000L;
            this.cancelTimeout();
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout() {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null && this._timeoutMs > 0L) {
            this._event.setTimeoutTask(scheduler.schedule(new AsyncTimeout(), this._timeoutMs, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimeout() {
        AsyncContextEvent event;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            event = this._event;
        }
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._async == Async.EXPIRED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.ASYNCWAIT || this._state == State.DISPATCHED && this._async == Async.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleting() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsyncStarted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._state == State.DISPATCHED) {
                return this._async != null;
            }
            return this._async == Async.STARTED || this._async == Async.EXPIRING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return !this._initial || this._async != null;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextHandler getContextHandler() {
        ContextHandler.Context context;
        AsyncContextEvent event;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            event = this._event;
        }
        if (event != null && (context = (ContextHandler.Context)event.getServletContext()) != null) {
            return context.getContextHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletResponse getServletResponse() {
        AsyncContextEvent event;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            event = this._event;
        }
        if (event != null && event.getSuppliedResponse() != null) {
            return event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadPossible() {
        boolean handle;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._asyncRead = true;
            handle = this._state == State.ASYNCWAIT;
        }
        if (handle) {
            this._channel.execute(this._channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWritePossible() {
        boolean handle;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._asyncWrite = true;
            handle = this._state == State.ASYNCWAIT;
        }
        if (handle) {
            this._channel.execute(this._channel);
        }
    }

    public class AsyncTimeout
    implements Runnable {
        @Override
        public void run() {
            HttpChannelState.this.expired();
        }
    }

    public static enum Async {
        STARTED,
        DISPATCH,
        COMPLETE,
        EXPIRING,
        EXPIRED;

    }

    public static enum Action {
        REQUEST_DISPATCH,
        ASYNC_DISPATCH,
        ASYNC_EXPIRED,
        WRITE_CALLBACK,
        READ_CALLBACK,
        WAIT,
        COMPLETE;

    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNCWAIT,
        ASYNCIO,
        COMPLETING,
        COMPLETED;

    }
}

