/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.compare;

import edu.mit.jwi.data.compare.CommentComparator;
import edu.mit.jwi.data.compare.ICommentDetector;
import edu.mit.jwi.data.compare.ILineComparator;

public class DataLineComparator
implements ILineComparator {
    private static DataLineComparator instance;
    private final CommentComparator detector;

    public static DataLineComparator getInstance() {
        if (instance == null) {
            instance = new DataLineComparator(CommentComparator.getInstance());
        }
        return instance;
    }

    protected DataLineComparator(CommentComparator detector) {
        if (detector == null) {
            throw new NullPointerException();
        }
        this.detector = detector;
    }

    @Override
    public int compare(String s1, String s2) {
        int l2;
        boolean c2;
        boolean c1 = this.detector.isCommentLine(s1);
        if (c1 & (c2 = this.detector.isCommentLine(s2))) {
            return this.detector.compare(s1, s2);
        }
        if (c1 & !c2) {
            return -1;
        }
        if (!c1 & c2) {
            return 1;
        }
        int i1 = s1.indexOf(32);
        int i2 = s2.indexOf(32);
        if (i1 == -1) {
            i1 = s1.length();
        }
        if (i2 == -1) {
            i2 = s2.length();
        }
        String sub1 = s1.substring(0, i1);
        String sub2 = s2.substring(0, i2);
        int l1 = Integer.parseInt(sub1);
        if (l1 < (l2 = Integer.parseInt(sub2))) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        return 0;
    }

    @Override
    public ICommentDetector getCommentDetector() {
        return this.detector;
    }
}

