/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbEui;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.ToSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToBaseSpellingVariants
extends Transformation
implements Cloneable {
    private static final String INFO = "Base Spelling Variants";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> out = new Vector<LexItem>();
        long inCat = in.GetSourceCategory().GetValue();
        Vector<InflectionRecord> records = ToSpellingVariants.SpellingVariant(in.GetSourceTerm(), conn);
        for (int i = 0; i < records.size(); ++i) {
            InflectionRecord record = records.elementAt(i);
            String term = record.GetInflectedTerm();
            long curCat = record.GetCategory();
            long curInfl = record.GetInflection();
            if (!InputFilter.IsLegal(inCat, curCat)) continue;
            LexItem tempIn = new LexItem(in, false);
            tempIn.SetSourceTerm(term);
            tempIn.SetSourceCategory(curCat);
            tempIn.SetSourceInflection(curInfl);
            Vector<InflectionRecord> bases = ToBaseSpellingVariants.UninflectTerm(tempIn, conn, trie);
            for (int j = 0; j < bases.size(); ++j) {
                InflectionRecord rec = bases.elementAt(j);
                String uninflectedTerm = rec.GetUninflectedTerm();
                in.SetSourceCategory(rec.GetCategory());
                in.SetSourceInflection(rec.GetInflection());
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = INFO;
                }
                if (mutateFlag) {
                    String eui = DbEui.GetEuisByUnflectedTermCat(uninflectedTerm, rec.GetCategory(), conn);
                    mutate = eui + GlobalBehavior.GetInstance().GetFieldSeparator();
                }
                LexItem temp = ToBaseSpellingVariants.UpdateLexItem(in, uninflectedTerm, 23, rec.GetCategory(), Inflection.GetBitValue(0), details, mutate);
                ToBaseSpellingVariants.AddCurToOut(out, temp);
            }
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToBaseSpellingVariants.GetTestStr(args, "color");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToBaseSpellingVariants.Mutate(in, conn, trie, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToBaseSpellingVariants.PrintResults(in, outs);
    }

    private static Vector<InflectionRecord> UninflectTerm(LexItem in, Connection conn, RamTrie trie) {
        String inStr = in.GetSourceTerm();
        Vector<InflectionRecord> out = new Vector<InflectionRecord>();
        try {
            out = DbUninflection.GetUninflections(inStr, conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private static void AddCurToOut(Vector<LexItem> out, LexItem cur) {
        if (out.size() == 0) {
            out.addElement(cur);
        } else {
            boolean existTerm = false;
            for (int i = 0; i < out.size(); ++i) {
                LexItem temp = out.elementAt(i);
                if (!temp.GetTargetTerm().equals(cur.GetTargetTerm()) || temp.GetTargetCategory().GetValue() != cur.GetTargetCategory().GetValue()) continue;
                existTerm = true;
                break;
            }
            if (!existTerm) {
                out.addElement(cur);
            }
        }
    }
}

