/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFruitfulVariantsLex
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Known Fruitful Variants";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trieI, RamTrie trieD, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> originalSet = ToFruitfulVariants.GetNoOperationSet(in, conn, trieI, detailsFlag, true);
        Vector<LexItem> variantSet = ToFruitfulVariants.GetVariantSet(in, conn, trieI, trieD, detailsFlag);
        Vector<LexItem> sivSet = ToFruitfulVariants.GetSpellingAndInflections(variantSet, conn, trieI, detailsFlag, 1);
        originalSet = ToFruitfulVariants.AddToVariantList(originalSet, sivSet);
        String flowName = Flow.GetBitName(45, 1);
        Vector<LexItem> outs = ToFruitfulVariants.GetFinalSet(originalSet, flowName, mutateFlag);
        return outs;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFruitfulVariantsLex.GetTestStr(args, "neurological");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            RamTrie trieI = new RamTrie(true, minTermLen, lvgDir, 0);
            RamTrie trieD = new RamTrie(false, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToFruitfulVariantsLex.Mutate(in, conn, trieI, trieD, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFruitfulVariantsLex.PrintResults(in, outs);
    }
}

