/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbNominalization;
import gov.nih.nlm.nls.lvg.Db.NominalizationRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToNominalization
extends Transformation {
    private static final String INFO = "Nominalization";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> out = ToNominalization.GetNominalization(in, conn, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToNominalization.GetTestStr(args, "able");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToNominalization.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToNominalization.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetNominalization(LexItem in, Connection conn, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String inStr = in.GetSourceTerm();
        Vector<LexItem> out = new Vector<LexItem>();
        try {
            Vector<NominalizationRecord> nomList = DbNominalization.GetNominalizations(inStr, conn);
            for (int i = 0; i < nomList.size(); ++i) {
                NominalizationRecord record = nomList.elementAt(i);
                String inTerm = record.GetNominalization1();
                String inEui = record.GetEui1();
                long inCat = record.GetCat1();
                String nomTerm = record.GetNominalization2();
                String nomEui = record.GetEui2();
                long nomCat = record.GetCat2();
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr;
                }
                if (mutateFlag) {
                    String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
                    mutate = inEui + fs + Category.ToName(inCat) + fs + nomEui + fs;
                }
                LexItem temp = ToNominalization.UpdateLexItem(in, nomTerm, 57, nomCat, Inflection.GetBitValue(0), details, mutate);
                out.addElement(temp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }
}

