/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Util.Vec;
import java.util.ArrayList;
import java.util.Vector;

public class Category
extends BitMaskBase {
    public static final int ADJ_BIT = 0;
    public static final int ADV_BIT = 1;
    public static final int AUX_BIT = 2;
    public static final int COMPL_BIT = 3;
    public static final int CONJ_BIT = 4;
    public static final int DET_BIT = 5;
    public static final int MODAL_BIT = 6;
    public static final int NOUN_BIT = 7;
    public static final int PREP_BIT = 8;
    public static final int PRON_BIT = 9;
    public static final int VERB_BIT = 10;
    public static final int TOTAL_BITS = 11;
    public static final long ALL_BIT_VALUE = 2047L;
    public static final long NO_BIT_VALUE = 0L;
    private static final ArrayList<Vector<String>> BIT_STR = new ArrayList(63);

    public Category() {
        super(2047L, BIT_STR);
    }

    public Category(long value) {
        super(value, 2047L, BIT_STR);
    }

    public static long ToValue(String valueStr) {
        return Category.ToValue(valueStr, BIT_STR);
    }

    public static String ToName(long value) {
        return Category.ToName(value, 2047L, BIT_STR);
    }

    public static String GetBitName(int bitValue) {
        return Category.GetBitName(bitValue, 0);
    }

    public static String GetBitName(int bitValue, int index) {
        return Category.GetBitName(bitValue, index, BIT_STR);
    }

    public static long Enumerate(String valueStr) {
        return Category.Enumerate(valueStr, BIT_STR);
    }

    public static Vector<Long> ToValues(long value) {
        return Category.ToValues(value, 11);
    }

    public static long[] ToValuesArray(long value) {
        Vector<Long> out = Category.ToValues(value, 11);
        return Vec.ToArray(out);
    }

    public static void main(String[] args) {
        System.out.println("----- static methods -----");
        System.out.println(" -  ToValue(adv+adv+noun+verb): " + Category.ToValue("adv+adj+noun+verb"));
        System.out.println(" -  ToName(1155): " + Category.ToName(1155L));
        Vector<Long> values = Category.ToValues(1155L);
        for (int i = 0; i < values.size(); ++i) {
            System.out.println(" - Category.ToValues(1155): " + values.elementAt(i));
        }
        long[] valuesArray = Category.ToValuesArray(1155L);
        for (int i = 0; i < valuesArray.length; ++i) {
            System.out.println(" - Category.ToValues(1155): " + valuesArray[i]);
        }
        System.out.println(" -  ToValue(noun): " + Category.ToValue("noun"));
        System.out.println(" -  GetBitValue(Category.NOUN_BIT): " + Category.GetBitValue(7));
        System.out.println("----- object methods -----");
        Category c1 = new Category(1155L);
        System.out.println(" - c1.GetValue(): " + c1.GetValue());
        System.out.println(" - c1.GetName(): " + c1.GetName());
        c1.SetValue(2047L);
        System.out.println(" - c1.GetValue(): " + c1.GetValue());
        System.out.println(" - c1.GetName(): " + c1.GetName());
    }

    static {
        for (int i = 0; i < 63; ++i) {
            BIT_STR.add(i, new Vector());
        }
        BIT_STR.get(0).addElement("adj");
        BIT_STR.get(0).addElement("adjective");
        BIT_STR.get(0).addElement("ADJ");
        BIT_STR.get(1).addElement("adv");
        BIT_STR.get(1).addElement("adverb");
        BIT_STR.get(1).addElement("ADV");
        BIT_STR.get(2).addElement("aux");
        BIT_STR.get(2).addElement("auxiliary");
        BIT_STR.get(3).addElement("compl");
        BIT_STR.get(3).addElement("complementizer");
        BIT_STR.get(4).addElement("conj");
        BIT_STR.get(4).addElement("conjunction");
        BIT_STR.get(4).addElement("CON");
        BIT_STR.get(4).addElement("con");
        BIT_STR.get(5).addElement("det");
        BIT_STR.get(5).addElement("determiner");
        BIT_STR.get(5).addElement("DET");
        BIT_STR.get(6).addElement("modal");
        BIT_STR.get(7).addElement("noun");
        BIT_STR.get(7).addElement("NOM");
        BIT_STR.get(7).addElement("NPR");
        BIT_STR.get(8).addElement("prep");
        BIT_STR.get(8).addElement("preposition");
        BIT_STR.get(8).addElement("PRE");
        BIT_STR.get(8).addElement("pre");
        BIT_STR.get(9).addElement("pron");
        BIT_STR.get(9).addElement("pronoun");
        BIT_STR.get(10).addElement("verb");
        BIT_STR.get(10).addElement("VER");
        BIT_STR.get(10).addElement("ver");
    }
}

