/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.CmdLineTools;

import gov.nih.nlm.nls.lvg.Api.FieldsApi;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Tools.CmdLineTools.FieldsHelp;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class fields
extends SystemOption {
    private boolean runFlag_ = true;
    private boolean promptFlag_ = false;
    private boolean fileOutput_ = false;
    private String separator_ = "|";
    private String outputTerm_ = new String();
    private String promptStr_ = null;
    private Vector<Integer> outputFieldList_ = new Vector();
    private BufferedReader inReader_ = null;
    private BufferedWriter outWriter_ = null;

    public fields() {
        this.Init();
    }

    public static void main(String[] args) {
        Option io = Option.GetOptonByArgs(args);
        fields fieldsObj = new fields();
        Out out = new Out();
        if (SystemOption.CheckSyntax(io, fieldsObj.GetOption(), false, true)) {
            fieldsObj.ExecuteCommands(io, fieldsObj.GetOption(), out);
            if (fieldsObj.GetRunFlag()) {
                fieldsObj.GetVariants(out);
            }
        } else {
            FieldsHelp.FieldsHelp(fieldsObj.GetOutWriter(), fieldsObj.GetFileOutput(), out);
        }
        fieldsObj.Close();
    }

    public void GetVariants(Out out) {
        if (this.inReader_ == null) {
            try {
                this.inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        try {
            do {
                if (!this.promptFlag_) continue;
                this.GetPrompt(out);
            } while (this.LineHandler(this.inReader_.readLine(), out));
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption, Out out) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (fields.CheckOption(nameItem, "-F:INT")) {
            Integer fieldNum = new Integer(nameItem.GetOptionArgument());
            this.outputFieldList_.addElement(fieldNum);
        } else if (fields.CheckOption(nameItem, "-h")) {
            FieldsHelp.FieldsHelp(this.outWriter_, this.fileOutput_, out);
            this.runFlag_ = false;
        } else if (fields.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (fields.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    this.inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (fields.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    this.fileOutput_ = true;
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (fields.CheckOption(nameItem, "-p")) {
            this.promptFlag_ = true;
        } else if (fields.CheckOption(nameItem, "-s:STR")) {
            this.separator_ = nameItem.GetOptionArgument();
            if (this.separator_.equals("\\t")) {
                this.separator_ = new Character('\t').toString();
            }
        } else if (fields.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "fields.2016";
                out.Println(this.outWriter_, releaseStr, this.fileOutput_, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.runFlag_ = false;
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-F:INT -h -hs -i:STR -o:STR -p -s:STR -v";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-F", "Copy_Field_To_Outputs");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-v", "Version");
    }

    private void Close() {
        try {
            if (this.outWriter_ != null) {
                this.outWriter_.close();
            }
            if (this.inReader_ != null) {
                this.inReader_.close();
            }
        }
        catch (Exception e) {
            System.err.println("Err@fields.Close(): " + e.toString());
        }
    }

    private void GetPrompt(Out out) throws IOException {
        out.Println(this.outWriter_, this.promptStr_, this.fileOutput_, false);
    }

    private boolean LineHandler(String line, Out out) throws IOException {
        if (line == null) {
            return false;
        }
        String outStr = FieldsApi.Mutate(line, this.separator_, this.outputFieldList_);
        out.Println(this.outWriter_, outStr, this.fileOutput_, false);
        return true;
    }

    private boolean GetRunFlag() {
        return this.runFlag_;
    }

    private boolean GetFileOutput() {
        return this.fileOutput_;
    }

    private BufferedWriter GetOutWriter() {
        return this.outWriter_;
    }

    private void Init() {
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        try {
            this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

