/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.CmdLineTools;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Flows.ToTokenize;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Tools.CmdLineTools.WordIndHelp;
import gov.nih.nlm.nls.lvg.Util.In;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Vector;

public class wordInd
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private boolean runFlag_ = true;
    private boolean noOutputFlag_ = false;
    private boolean promptFlag_ = false;
    private boolean reserveCaseFlag_ = false;
    private boolean fileOutput_ = false;
    private int termFieldNum_ = 1;
    private String separator_ = "|";
    private String outputTerm_ = new String();
    private String promptStr_ = null;
    private Vector<Integer> outputFieldList_ = new Vector();
    private BufferedReader inReader_ = null;
    private BufferedWriter outWriter_ = null;

    public wordInd() {
        this.Init();
    }

    public static void main(String[] args) {
        Option io = Option.GetOptonByArgs(args);
        wordInd wordIndObj = new wordInd();
        Out out = new Out();
        if (SystemOption.CheckSyntax(io, wordIndObj.GetOption(), false, true)) {
            wordIndObj.ExecuteCommands(io, wordIndObj.GetOption(), out);
            if (wordIndObj.GetRunFlag()) {
                wordIndObj.GetVariants(out);
            }
        } else {
            WordIndHelp.WordIndHelp(wordIndObj.GetOutWriter(), wordIndObj.GetFileOutput(), out);
        }
        wordIndObj.Close();
    }

    public void GetVariants(Out out) {
        if (this.inReader_ == null) {
            try {
                this.inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        try {
            do {
                if (!this.promptFlag_) continue;
                this.GetPrompt(out);
            } while (this.LineHandler(this.inReader_.readLine(), out));
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption, Out out) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (wordInd.CheckOption(nameItem, "-c")) {
            this.reserveCaseFlag_ = true;
        } else if (wordInd.CheckOption(nameItem, "-F:INT")) {
            Integer fieldNum = new Integer(nameItem.GetOptionArgument());
            this.outputFieldList_.addElement(fieldNum);
        } else if (wordInd.CheckOption(nameItem, "-h")) {
            WordIndHelp.WordIndHelp(this.outWriter_, this.fileOutput_, out);
            this.runFlag_ = false;
        } else if (wordInd.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (wordInd.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    this.inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (wordInd.CheckOption(nameItem, "-n")) {
            this.noOutputFlag_ = true;
        } else if (wordInd.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    this.fileOutput_ = true;
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (wordInd.CheckOption(nameItem, "-p")) {
            this.promptFlag_ = true;
        } else if (wordInd.CheckOption(nameItem, "-s:STR")) {
            this.separator_ = nameItem.GetOptionArgument();
            if (this.separator_.equals("\\t")) {
                this.separator_ = new Character('\t').toString();
            }
        } else if (wordInd.CheckOption(nameItem, "-t:INT")) {
            this.termFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (wordInd.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "wordInd.2016";
                out.Println(this.outWriter_, releaseStr, this.fileOutput_, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.runFlag_ = false;
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-c -F:INT -h -hs -i:STR -n -o:STR -p -s:STR -t:INT -v";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-c", "Reserve_Cases");
        this.systemOption_.SetFlagFullName("-F", "Copy_Field_To_Outputs");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Term_Field");
        this.systemOption_.SetFlagFullName("-v", "Version");
    }

    private void Close() {
        try {
            if (this.outWriter_ != null) {
                this.outWriter_.close();
            }
            if (this.inReader_ != null) {
                this.inReader_.close();
            }
        }
        catch (Exception e) {
            System.err.println("Err@wordInd.Close(): " + e.toString());
        }
    }

    private void GetPrompt(Out out) throws IOException {
        out.Println(this.outWriter_, this.promptStr_, this.fileOutput_, false);
    }

    private boolean LineHandler(String line, Out out) throws SQLException, IOException {
        LexItem in;
        Vector<LexItem> result;
        if (line == null) {
            return false;
        }
        String inTerm = In.GetField(line, this.separator_, this.termFieldNum_);
        this.outputTerm_ = In.GetOutTerm(line, this.separator_, this.outputFieldList_);
        if (!this.reserveCaseFlag_) {
            inTerm = inTerm.toLowerCase();
        }
        if ((result = ToTokenize.Mutate(in = new LexItem(inTerm), false, false)).size() == 0) {
            if (this.noOutputFlag_) {
                out.Println(this.outWriter_, this.outputTerm_ + NO_OUTPUT_STR, this.fileOutput_, false);
            }
        } else {
            for (int i = 0; i < result.size(); ++i) {
                LexItem temp = result.elementAt(i);
                out.Println(this.outWriter_, this.outputTerm_ + temp.GetTargetTerm(), this.fileOutput_, false);
            }
        }
        return true;
    }

    private boolean GetRunFlag() {
        return this.runFlag_;
    }

    private boolean GetFileOutput() {
        return this.fileOutput_;
    }

    private BufferedWriter GetOutWriter() {
        return this.outWriter_;
    }

    private void Init() {
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        try {
            this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

