/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.RuleException;
import gov.nih.nlm.nls.lvg.Trie.TrieNode;
import gov.nih.nlm.nls.lvg.Trie.WildCard;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TrieTree {
    private boolean wildCard_ = false;
    private TrieNode root_ = null;
    private TrieNode curNode_ = null;
    private TrieNode foundNode_ = null;
    private Vector<TrieNode> foundNodeList_ = null;
    private int nodeNum_ = 1;
    private int ruleNum_ = 0;
    private int exceptionNum_ = 0;
    private boolean firstTime_ = true;
    private InflectionRule curRule_ = null;
    private static final String RULE_STR = "RULE: ";
    private static final String EXCEPTION_STR = "EXCEPTION: ";
    private static final String FILE_STR = "FILE: ";

    public TrieTree() {
        this.root_ = new TrieNode('$', 0);
    }

    public TrieTree(boolean wildCard) {
        this.wildCard_ = wildCard;
        this.root_ = new TrieNode('$', 0);
    }

    public void SetWildCard(boolean wildCard) {
        this.wildCard_ = wildCard;
    }

    public void LoadRulesFromFile(String dir, String fName, boolean reverse, boolean duplicateFlag) {
        if (fName == null || dir == null) {
            return;
        }
        String inFile = dir + fName;
        this.LoadRulesFromFile(inFile, reverse, duplicateFlag);
    }

    public void LoadRulesFromFile(String inFile, boolean reverse, boolean duplicateFlag) {
        try {
            String line = null;
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            while ((line = in.readLine()) != null) {
                StringTokenizer buf;
                if (line.length() <= 0) continue;
                if (line.startsWith(EXCEPTION_STR)) {
                    String exception = line.substring(EXCEPTION_STR.length());
                    line = this.ReverseException(exception, reverse);
                    this.curRule_.AddException(line);
                    ++this.exceptionNum_;
                    continue;
                }
                if (line.startsWith(RULE_STR)) {
                    buf = new StringTokenizer(line, " ");
                    buf.nextToken();
                    line = this.ReverseRule(buf.nextToken(), reverse);
                    this.AddRule(line, duplicateFlag);
                    continue;
                }
                if (!line.startsWith(FILE_STR)) continue;
                buf = new StringTokenizer(line, " ");
                buf.nextToken();
                String newFileName = buf.nextToken();
                File inFileObj = new File(inFile);
                String dir = inFileObj.getParent();
                String newInFile = dir + "/" + newFileName;
                this.LoadRulesFromFile(newInFile, reverse, duplicateFlag);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            System.err.println("**Err@TrieTree.LoadRulesFromFile( ): problem of opening/reading file: " + inFile);
        }
    }

    public Vector<TrieNode> FindRule(String inStr) {
        String curStr = inStr.trim() + '$';
        char[] inCharArray = curStr.toCharArray();
        this.foundNodeList_ = new Vector();
        this.foundNodeList_.addElement(this.root_);
        this.FindNode(this.root_, inCharArray);
        return this.foundNodeList_;
    }

    public void PrintTrie(boolean details, boolean rulesFlag, boolean exceptionFlag) {
        this.PrintTrie(this.root_, details, rulesFlag, exceptionFlag);
    }

    public TrieNode GetRoot() {
        return this.root_;
    }

    public static void main(String[] args) {
        TrieTree rules = new TrieTree();
        rules.SetWildCard(true);
        rules.LoadRulesFromFile("../data/rules/", "im.rul", false, false);
        System.out.println("----- result ---------");
        rules.PrintTrie(rules.GetRoot(), true, true, true);
    }

    private String ReverseException(String inLine, boolean reverse) {
        String outLine = inLine;
        if (reverse) {
            RuleException exception = new RuleException(inLine);
            exception.Reverse();
            outLine = exception.GetExceptionStr();
        }
        return outLine;
    }

    private String ReverseRule(String inLine, boolean reverse) {
        String outLine = inLine;
        if (reverse) {
            InflectionRule rule = new InflectionRule(inLine);
            rule.Reverse();
            outLine = rule.GetRuleStr();
        }
        return outLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean FindNode(TrieNode node, char[] charArray) {
        char curKey = node.GetKey();
        int curLevel = node.GetLevel();
        int arraySize = Array.getLength(charArray);
        int index = arraySize - 1 - curLevel;
        if (!WildCard.IsMatchKey(curKey, index, charArray)) return false;
        if (node.GetRules() != null) {
            this.foundNode_ = node;
            this.AddNodeToFoundList();
        }
        if (index == 0) {
            return true;
        }
        boolean oneChildMatch = false;
        if (node.GetChild() == null) return true;
        for (int i = 0; i < node.GetChild().size(); ++i) {
            TrieNode childNode = node.GetChild().elementAt(i);
            if (!this.FindNode(childNode, charArray)) continue;
            oneChildMatch = true;
        }
        if (!oneChildMatch) return true;
        this.AddNodeToFoundList();
        return true;
    }

    private void AddNodeToFoundList() {
        boolean duplicateNode = false;
        for (int i = 0; i < this.foundNodeList_.size(); ++i) {
            if (this.foundNode_ != this.foundNodeList_.elementAt(i)) continue;
            duplicateNode = true;
            break;
        }
        if (!duplicateNode) {
            this.foundNodeList_.addElement(this.foundNode_);
        }
    }

    private void AddRule(String line, boolean duplicateFlag) {
        this.curRule_ = new InflectionRule(line);
        String inSuffix = this.curRule_.GetInSuffix();
        char curChar = ' ';
        this.curNode_ = this.root_;
        for (int i = inSuffix.length() - 1 - 1; i >= 0; --i) {
            curChar = inSuffix.charAt(i);
            int level = inSuffix.length() - 1 - i;
            this.AddTrieNode(curChar, level);
        }
        if (this.curNode_.GetRules() == null) {
            Vector<InflectionRule> rules = new Vector<InflectionRule>();
            rules.addElement(this.curRule_);
            this.curNode_.SetRules(rules);
            ++this.ruleNum_;
        } else {
            boolean duplicateRule = false;
            for (int i = 0; i < this.curNode_.GetRules().size(); ++i) {
                InflectionRule tempRule = this.curNode_.GetRules().elementAt(i);
                if (!this.curRule_.equals(tempRule)) continue;
                if (duplicateFlag) {
                    System.out.println("* Warning: duplicate rule (" + this.curRule_.GetRuleStr() + ")");
                }
                duplicateRule = true;
                break;
            }
            if (!duplicateRule) {
                int size;
                int insertIndex = size = this.curNode_.GetRules().size();
                long inCategory = this.curRule_.GetInCategory();
                for (int i = 0; i < this.curNode_.GetRules().size(); ++i) {
                    InflectionRule tempRule = this.curNode_.GetRules().elementAt(i);
                    if (this.GetDistance(inCategory, tempRule.GetInCategory()) <= 0) continue;
                    insertIndex = i;
                    break;
                }
                this.curNode_.GetRules().add(insertIndex, this.curRule_);
                ++this.ruleNum_;
            }
        }
    }

    private int GetDistance(long inCategory, long curCategory) {
        int in = this.ToPriority(inCategory);
        int cur = this.ToPriority(curCategory);
        int dis = cur - in;
        return dis;
    }

    private int ToPriority(long category) {
        int priority = 0;
        if (category == Category.ToValue("noun")) {
            priority = 1;
        } else if (category == Category.ToValue("verb")) {
            priority = 2;
        } else if (category == Category.ToValue("adj")) {
            priority = 3;
        } else if (category == Category.ToValue("adv")) {
            priority = 4;
        }
        return priority;
    }

    private void AddTrieNode(char key, int level) {
        char parentKey = this.curNode_.GetKey();
        if (this.curNode_ != null) {
            if (this.curNode_.GetChild() == null) {
                this.curNode_.SetChild(new Vector<TrieNode>());
            }
            boolean found = false;
            Vector<TrieNode> childList = this.curNode_.GetChild();
            for (int i = 0; i < childList.size(); ++i) {
                TrieNode curChild = childList.elementAt(i);
                if (key != curChild.GetKey()) continue;
                this.curNode_ = curChild;
                found = true;
                break;
            }
            if (!found) {
                TrieNode newNode = new TrieNode(key, level);
                this.InsertNode(this.curNode_.GetChild(), newNode);
                this.curNode_ = newNode;
                ++this.nodeNum_;
            }
        }
    }

    private void InsertNode(Vector<TrieNode> child, TrieNode node) {
        int index = this.FindIndex(child, node);
        child.insertElementAt(node, index);
    }

    private int FindIndex(Vector<TrieNode> child, TrieNode node) {
        int size;
        int index = size = child.size();
        char key = node.GetKey();
        for (int i = 0; i < size; ++i) {
            TrieNode curNode = child.elementAt(i);
            if (curNode.GetKey() < key) continue;
            index = i;
            break;
        }
        return index;
    }

    private void PrintTrie(TrieNode node, boolean details, boolean rulesFlag, boolean exceptionFlag) {
        Vector<InflectionRule> rules;
        if (this.firstTime_) {
            this.firstTime_ = false;
            System.out.println("======== Trie Tree Information =========");
            System.out.println("Number of nodes: " + this.nodeNum_);
            System.out.println("Number of rules: " + this.ruleNum_);
            System.out.println("Number of exceptions: " + this.exceptionNum_);
            System.out.println("----------------------------------------");
        }
        System.out.print("--");
        for (int i = 0; i < node.GetLevel(); ++i) {
            System.out.print("---");
        }
        System.out.print(node.GetKey());
        if (details) {
            int cSize = node.GetChild() == null ? 0 : node.GetChild().size();
            int rSize = node.GetRules() == null ? 0 : node.GetRules().size();
            System.out.print(" (child: " + cSize + "; rule: " + rSize + ")");
        }
        System.out.print(System.getProperty("line.separator").toString());
        if (rulesFlag && (rules = node.GetRules()) != null) {
            for (int i = 0; i < rules.size(); ++i) {
                Hashtable<String, String> exceptions;
                InflectionRule rule = rules.elementAt(i);
                System.out.print("  ");
                for (int j = 0; j < node.GetLevel(); ++j) {
                    System.out.print("   ");
                }
                System.out.print("R-" + i + ": '" + rule.GetRuleStr() + "'");
                int eSize = rule.GetExceptions() == null ? 0 : rule.GetExceptions().size();
                System.out.println(" (Exceptions: " + eSize + ")");
                if (!exceptionFlag || (exceptions = rule.GetExceptions()) == null) continue;
                Enumeration<String> keyEn = exceptions.keys();
                Enumeration<String> eleEn = exceptions.elements();
                int k = 0;
                while (keyEn.hasMoreElements()) {
                    System.out.print("      ");
                    for (int l = 0; l < node.GetLevel(); ++l) {
                        System.out.print("   ");
                    }
                    String key = keyEn.nextElement();
                    String ele = eleEn.nextElement();
                    System.out.println("E-" + k + ": '" + key + "' => '" + ele + "'");
                    ++k;
                }
            }
        }
        if (node.GetChild() != null) {
            for (int i = 0; i < node.GetChild().size(); ++i) {
                TrieNode childNode = node.GetChild().elementAt(i);
                this.PrintTrie(childNode, details, rulesFlag, exceptionFlag);
            }
        }
    }
}

