/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import java.util.StringTokenizer;
import java.util.Vector;

public class Strip {
    public static String StripStrings(String inStr, Vector<String> strList, boolean caseSensitive) {
        String out = inStr;
        for (int i = 0; i < strList.size(); ++i) {
            String str = strList.elementAt(i);
            out = Strip.StripString(out, str, caseSensitive);
        }
        return out;
    }

    public static String StripString(String inStr, String str, boolean caseSensitive) {
        String out = inStr;
        int strSize = str.length();
        int index = -1;
        index = caseSensitive ? out.indexOf(str, 0) : out.toLowerCase().indexOf(str.toLowerCase(), 0);
        while (index != -1) {
            String after;
            String before;
            String temp;
            int inSize = out.length();
            int beginIndex = index - 1;
            int endIndex = index + strSize + 1;
            if (index == 0) {
                beginIndex = 0;
            }
            if (index == inSize - strSize) {
                endIndex = inSize;
            }
            if ((temp = out.substring(beginIndex, endIndex).trim()).charAt(0) == ',') {
                temp = temp.substring(1, temp.length());
            }
            if (caseSensitive) {
                if (temp.equals(str)) {
                    before = out.substring(0, beginIndex);
                    after = out.substring(endIndex, inSize);
                    out = before + " " + after;
                    index = out.indexOf(str, beginIndex);
                    continue;
                }
                index = out.indexOf(str, beginIndex + 2);
                continue;
            }
            if (temp.equalsIgnoreCase(str)) {
                before = out.substring(0, beginIndex);
                after = out.substring(endIndex, inSize);
                out = before + " " + after;
                index = out.toLowerCase().indexOf(str.toLowerCase(), beginIndex);
                continue;
            }
            index = out.toLowerCase().indexOf(str.toLowerCase(), beginIndex + 2);
        }
        return out.trim();
    }

    public static String StripWords(String inStr, Vector<String> wordList, boolean caseSensitive) {
        StringTokenizer buf = new StringTokenizer(inStr, " \t");
        Vector<String> inStrList = new Vector<String>();
        String temp = null;
        String out = "";
        while (buf.hasMoreTokens()) {
            temp = buf.nextToken();
            boolean foundWord = false;
            for (int i = 0; i < wordList.size(); ++i) {
                String word = wordList.elementAt(i);
                if (caseSensitive && temp.equals(word)) {
                    foundWord = true;
                    break;
                }
                if (caseSensitive || !temp.toLowerCase().equals(word)) continue;
                foundWord = true;
                break;
            }
            if (foundWord) continue;
            inStrList.addElement(temp);
        }
        for (int i = 0; i < inStrList.size(); ++i) {
            out = out + (String)inStrList.elementAt(i) + " ";
        }
        return out.trim();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("** Usage: java StripWord <inStr>");
        } else {
            String inStr = args[0];
            Vector<String> strList = Strip.GetStringList();
            String outStr = Strip.StripStrings(inStr, strList, false);
            System.out.println("=> outStr: '" + outStr + "'");
        }
    }

    private static Vector<String> GetStringList() {
        Vector<String> strList = new Vector<String>(5);
        strList.addElement("of");
        strList.addElement("and");
        strList.addElement("with");
        strList.addElement("for");
        strList.addElement("nos");
        strList.addElement("to");
        strList.addElement("in");
        strList.addElement("by");
        strList.addElement("on");
        strList.addElement("the");
        strList.addElement("(non mesh)");
        return strList;
    }
}

