/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.libsvm;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.FeatureVectorFeaturesEncoder;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.jar.DataWriter_ImplBase;
import org.cleartk.ml.libsvm.GenericLibSvmClassifierBuilder;
import org.cleartk.ml.util.featurevector.FeatureVector;

public abstract class LibSvmDataWriter<CLASSIFIER_BUILDER_TYPE extends GenericLibSvmClassifierBuilder<? extends Classifier<OUTCOME_TYPE>, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE, MODEL_TYPE>, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE, MODEL_TYPE>
extends DataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE, FeatureVector, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> {
    public LibSvmDataWriter(File outputDirectory) throws IOException {
        super(outputDirectory);
        FeatureVectorFeaturesEncoder fe = new FeatureVectorFeaturesEncoder();
        fe.addEncoder((FeatureEncoder)new NumberEncoder());
        fe.addEncoder((FeatureEncoder)new BooleanEncoder());
        fe.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)fe);
    }

    public void writeEncoded(FeatureVector features, ENCODED_OUTCOME_TYPE outcome) throws CleartkProcessingException {
        String classString = this.encode(outcome);
        StringBuffer output = new StringBuffer();
        output.append(classString);
        for (FeatureVector.Entry entry : features) {
            if (Double.isInfinite(entry.value) || Double.isNaN(entry.value)) {
                throw CleartkEncoderException.invalidFeatureVectorValue((int)entry.index, (double)entry.value);
            }
            output.append(String.format(Locale.US, " %d:%.7f", entry.index, entry.value));
        }
        this.trainingDataWriter.println(output);
    }

    protected abstract String encode(ENCODED_OUTCOME_TYPE var1) throws CleartkEncoderException;
}

