/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import de.tudarmstadt.ukp.dkpro.core.api.resources.CompressionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceAccessException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourceUtils {
    private static Map<String, File> urlFileCache = new HashMap<String, File>();
    private static Map<String, File> classpathFolderCache = new HashMap<String, File>();
    private static final String XDG_RUNTIME_DIR_ENV_VAR = "XDG_RUNTIME_DIR";
    private static final String DKPRO_HOME_ENV_VAR = "DKPRO_HOME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getClasspathAsFolder(String aClasspathBase, boolean aCache) throws IOException {
        Map<String, File> map = classpathFolderCache;
        synchronized (map) {
            File folder;
            block10: {
                Resource[] roots;
                folder = classpathFolderCache.get(aClasspathBase);
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                if (aCache && folder != null && folder.exists()) break block10;
                folder = File.createTempFile("dkpro-package", "");
                folder.delete();
                FileUtils.forceMkdir((File)folder);
                for (Resource root : roots = resolver.getResources(aClasspathBase)) {
                    Resource[] resources;
                    String base = root.getURL().toString();
                    for (Resource resource : resources = resolver.getResources(base + "/**/*")) {
                        if (!resource.isReadable()) continue;
                        String res = resource.getURL().toString();
                        if (!res.startsWith(base)) {
                            throw new IOException("Resource location does not start with base location");
                        }
                        String relative = resource.getURL().toString().substring(base.length());
                        File target = new File(folder, relative).getAbsoluteFile();
                        if (target.getParentFile() != null) {
                            FileUtils.forceMkdir((File)target.getParentFile());
                        }
                        InputStream is = null;
                        FileOutputStream os = null;
                        try {
                            is = resource.getInputStream();
                            os = new FileOutputStream(target);
                            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly((InputStream)is);
                            IOUtils.closeQuietly(os);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        IOUtils.closeQuietly((OutputStream)os);
                        if (target.length() != 0L) continue;
                        FileUtils.deleteQuietly((File)target);
                    }
                }
                if (aCache) {
                    classpathFolderCache.put(aClasspathBase, folder);
                }
            }
            return folder;
        }
    }

    public static File getUrlAsFile(URL aUrl, boolean aCache) throws IOException {
        return ResourceUtils.getUrlAsFile(aUrl, aCache, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File getUrlAsFile(URL aUrl, boolean aCache, boolean aForceTemp) throws IOException {
        if (!aForceTemp && "file".equalsIgnoreCase(aUrl.getProtocol())) {
            try {
                return new File(aUrl.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        Map<String, File> map = urlFileCache;
        synchronized (map) {
            File file;
            block10: {
                file = urlFileCache.get(aUrl.toString());
                if (aCache && file != null && file.exists()) break block10;
                String suffix = FilenameUtils.getExtension((String)aUrl.getPath());
                if (suffix.length() == 0) {
                    suffix = "temp";
                }
                String name = FilenameUtils.getBaseName((String)aUrl.getPath());
                file = File.createTempFile(name, "." + suffix);
                file.deleteOnExit();
                InputStream is = null;
                FileOutputStream os = null;
                try {
                    is = aUrl.openStream();
                    os = new FileOutputStream(file);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
                if (aCache) {
                    urlFileCache.put(aUrl.toString(), file);
                }
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File getUrlAsExecutable(URL aUrl, boolean aCache) throws IOException {
        File file;
        block12: {
            Map<String, File> map = urlFileCache;
            synchronized (map) {
                file = urlFileCache.get(aUrl.toString());
                if (aCache && file != null && file.exists()) break block12;
                String name = FilenameUtils.getBaseName((String)aUrl.getPath());
                file = File.createTempFile(name, ".temp");
                file.setExecutable(true);
                if (!file.canExecute()) {
                    StringBuilder errorMessage = new StringBuilder(128);
                    errorMessage.append("Tried to use temporary folder, but seems it is not executable. Please check the permissions rights from your temporary folder.\n");
                    if (ResourceUtils.isEnvironmentVariableDefined(XDG_RUNTIME_DIR_ENV_VAR, errorMessage) && ResourceUtils.checkFolderPermissions(errorMessage, System.getenv(XDG_RUNTIME_DIR_ENV_VAR))) {
                        file = ResourceUtils.getFileAsExecutable(aUrl, System.getenv(XDG_RUNTIME_DIR_ENV_VAR));
                    } else if (ResourceUtils.isEnvironmentVariableDefined(DKPRO_HOME_ENV_VAR, errorMessage) && ResourceUtils.checkFolderPermissions(errorMessage, System.getenv(DKPRO_HOME_ENV_VAR) + File.separator + "temp")) {
                        file = ResourceUtils.getFileAsExecutable(aUrl, System.getenv(DKPRO_HOME_ENV_VAR) + File.separator + "temp");
                    } else {
                        if (!ResourceUtils.isUserHomeDefined(errorMessage) || !ResourceUtils.checkFolderPermissions(errorMessage, System.getProperty("user.home") + File.separator + ".dkpro" + File.separator + "temp")) {
                            throw new IOException(errorMessage.toString());
                        }
                        file = ResourceUtils.getFileAsExecutable(aUrl, System.getProperty("user.home") + File.separator + ".dkpro" + File.separator + "temp");
                    }
                }
                file.deleteOnExit();
                InputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = aUrl.openStream();
                    outputStream = new FileOutputStream(file);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                if (aCache) {
                    urlFileCache.put(aUrl.toString(), file);
                }
            }
        }
        return file;
    }

    public static InputStream resolveCompressedInputStream(InputStream is, String filename) throws IOException {
        return CompressionUtils.getInputStream(filename, is);
    }

    public static URL resolveLocation(String aLocation) throws IOException {
        return ResourceUtils.resolveLocation(aLocation, null, null);
    }

    public static URL resolveLocation(String aLocation, UimaContext aContext) throws IOException {
        return ResourceUtils.resolveLocation(aLocation, null, aContext);
    }

    public static URL resolveLocation(String aLocation, Object aCaller, UimaContext aContext) throws IOException {
        ClassLoader cl = null;
        if (aCaller != null) {
            cl = aCaller.getClass().getClassLoader();
        }
        return ResourceUtils.resolveLocation(aLocation, cl, aContext);
    }

    public static URL resolveLocation(String aLocation, ClassLoader aClassLoader, UimaContext aContext) throws IOException {
        String prefixClasspath;
        ClassLoader classLoader = aClassLoader;
        if (classLoader == null) {
            classLoader = ResourceUtils.class.getClassLoader();
        }
        if (aLocation.startsWith(prefixClasspath = "classpath:")) {
            URL url;
            String cpLocation = aLocation.substring(prefixClasspath.length());
            if (cpLocation.startsWith("/")) {
                cpLocation = cpLocation.substring(1);
            }
            if ((url = classLoader.getResource(cpLocation)) == null) {
                throw new FileNotFoundException("No file found at [" + aLocation + "]");
            }
            return url;
        }
        try {
            return new URL(aLocation);
        }
        catch (MalformedURLException e) {
            File file = new File(aLocation);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            if (aContext != null) {
                ResourceAccessException ex = null;
                URL url = null;
                try {
                    url = aContext.getResourceURL(aLocation);
                }
                catch (ResourceAccessException e2) {
                    ex = e2;
                }
                if (url == null) {
                    FileNotFoundException e3 = new FileNotFoundException("No file found at [" + aLocation + "]");
                    if (ex != null) {
                        e3.initCause(ex);
                    }
                    throw e3;
                }
                return url;
            }
            throw new FileNotFoundException("No file found at [" + aLocation + "]");
        }
    }

    private static boolean isUserHomeDefined(StringBuilder aStringBuilder) {
        boolean isDefined;
        boolean bl = isDefined = System.getProperty("user.home") != null;
        if (!isDefined) {
            aStringBuilder.append("user.home folder is not defined.");
        }
        return isDefined;
    }

    private static boolean isEnvironmentVariableDefined(String aVariable, StringBuilder aStringBuilder) {
        boolean isDefined;
        boolean bl = isDefined = System.getenv(aVariable) != null;
        if (!isDefined) {
            aStringBuilder.append("The environment variable: " + aVariable + " is not defined. Please specify this environment variable.\n");
        }
        return isDefined;
    }

    private static synchronized boolean checkFolderPermissions(StringBuilder aStringBuilder, String aDirectory) {
        File directory = new File(aDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.canRead()) {
            aStringBuilder.append("The directory [" + directory + "] is not readable. " + "Please check your permissions rights.\n");
            return false;
        }
        if (!directory.canWrite()) {
            aStringBuilder.append("The directory [" + directory + "] is not writable. " + "Please check your permissions rights.\n");
            return false;
        }
        return true;
    }

    private static synchronized File getFileAsExecutable(URL aUrl, String aDirectory) throws IOException {
        return File.createTempFile(FilenameUtils.getBaseName((String)aUrl.getPath()), ".temp", new File(aDirectory));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (classpathFolderCache != null) {
                    Map map = classpathFolderCache;
                    synchronized (map) {
                        for (Map.Entry e : classpathFolderCache.entrySet()) {
                            if (!((File)e.getValue()).isDirectory()) continue;
                            FileUtils.deleteQuietly((File)((File)e.getValue()));
                        }
                    }
                }
            }
        });
    }
}

