/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.baselines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class Utils {
    public static boolean validateLocationOfArgumentTypes(RelationExtractorAnnotator.IdentifiedAnnotationPair pair) {
        HashSet<Integer> okArg2Types = new HashSet<Integer>(Arrays.asList(2, 3, 5));
        IdentifiedAnnotation arg1 = pair.getArg1();
        IdentifiedAnnotation arg2 = pair.getArg2();
        int type1 = arg1.getTypeID();
        int type2 = arg2.getTypeID();
        return type1 == 6 && okArg2Types.contains(type2);
    }

    public static boolean validateDegreeOfArgumentTypes(RelationExtractorAnnotator.IdentifiedAnnotationPair pair) {
        IdentifiedAnnotation arg1;
        int type1;
        HashSet<Integer> okArg1Types = new HashSet<Integer>(Arrays.asList(2, 3));
        return okArg1Types.contains(type1 = (arg1 = pair.getArg1()).getTypeID());
    }

    public static int getDistance(JCas jCas, RelationExtractorAnnotator.IdentifiedAnnotationPair pair) {
        List baseTokens = JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)pair.getArg1(), (AnnotationFS)pair.getArg2());
        return baseTokens.size();
    }

    public static boolean isEnclosed(RelationExtractorAnnotator.IdentifiedAnnotationPair pair, TreebankNode np) {
        IdentifiedAnnotation arg1 = pair.getArg1();
        IdentifiedAnnotation arg2 = pair.getArg2();
        return np.getBegin() <= arg1.getBegin() && np.getEnd() >= arg1.getEnd() && np.getBegin() <= arg2.getBegin() && np.getEnd() >= arg2.getEnd();
    }

    public static List<TreebankNode> getNounPhrases(JCas identifiedAnnotationView, Sentence sentence) {
        List treebankNodes;
        ArrayList<TreebankNode> nounPhrases = new ArrayList<TreebankNode>();
        try {
            treebankNodes = JCasUtil.selectCovered((JCas)identifiedAnnotationView.getView("_InitialView"), TreebankNode.class, (AnnotationFS)sentence);
        }
        catch (CASException e) {
            treebankNodes = new ArrayList();
            System.out.println("couldn't get default sofa");
        }
        for (TreebankNode treebankNode : treebankNodes) {
            if (!treebankNode.getNodeType().equals("NP")) continue;
            nounPhrases.add(treebankNode);
        }
        return nounPhrases;
    }
}

