/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.DistanceExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamingExtractor1;

public class TokenFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private FeatureExtractor1 coveredText = new CoveredTextExtractor();
    private FeatureExtractor1 tokenContext = new CleartkExtractor(BaseToken.class, this.coveredText, new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()}), new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)});
    private FeatureExtractor1 mention1FeaturesExtractor = new NamingExtractor1("mention1", (FeatureExtractor1)new CombinedExtractor1(this.coveredText, this.tokenContext));
    private FeatureExtractor1 mention2FeaturesExtractor = new NamingExtractor1("mention2", (FeatureExtractor1)new CombinedExtractor1(this.coveredText, this.tokenContext));
    private CleartkExtractor tokensBetween = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)new NamingExtractor1("BetweenMentions", this.coveredText), new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})});
    private DistanceExtractor nTokensBetween = new DistanceExtractor(null, BaseToken.class);

    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation mention1, IdentifiedAnnotation mention2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        IdentifiedAnnotation arg1 = mention1;
        IdentifiedAnnotation arg2 = mention2;
        if (arg1 instanceof EventMention && (arg1 = TokenFeaturesExtractor.getExpandedEvent(jCas, mention1)) == null) {
            arg1 = mention1;
        }
        if (arg2 instanceof EventMention && (arg2 = TokenFeaturesExtractor.getExpandedEvent(jCas, mention2)) == null) {
            arg2 = mention2;
        }
        features.addAll(this.mention1FeaturesExtractor.extract(jCas, (Annotation)arg1));
        features.addAll(this.mention2FeaturesExtractor.extract(jCas, (Annotation)arg2));
        features.addAll(this.tokensBetween.extractBetween(jCas, (Annotation)arg1, (Annotation)arg2));
        features.addAll(this.nTokensBetween.extract(jCas, (Annotation)arg1, (Annotation)arg2));
        return features;
    }

    private static TreebankNode getExpandedEvent(JCas jCas, IdentifiedAnnotation mention) {
        List terms = JCasUtil.selectCovered(TerminalTreebankNode.class, (AnnotationFS)mention);
        if (terms == null || terms.size() == 0) {
            return null;
        }
        TreebankNode coveringNode = AnnotationTreeUtils.annotationNode((JCas)jCas, (Annotation)mention);
        if (coveringNode == null) {
            return (TreebankNode)terms.get(0);
        }
        String pos = ((TerminalTreebankNode)terms.get(0)).getNodeType();
        if (pos.startsWith("V")) {
            return coveringNode;
        }
        if (pos.startsWith("N")) {
            while (coveringNode != null && !coveringNode.getNodeType().equals("NP")) {
                coveringNode = coveringNode.getParent();
            }
        } else if (pos.startsWith("J")) {
            while (coveringNode != null && !coveringNode.getNodeType().equals("ADJP")) {
                coveringNode = coveringNode.getParent();
            }
        }
        if (coveringNode == null) {
            coveringNode = (TreebankNode)terms.get(0);
        }
        return coveringNode;
    }
}

