/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.eval;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.ctakes.relationextractor.ae.ModifierExtractorAnnotator;
import org.apache.ctakes.relationextractor.eval.ParameterSettings;
import org.apache.ctakes.relationextractor.eval.SHARPXMI;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;

public class ModifierExtractorEvaluation
extends SHARPXMI.Evaluation_ImplBase {
    public static final ParameterSettings BEST_PARAMETERS = new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new String[]{"-s", "0", "-c", "100.0"});
    private ParameterSettings parameterSettings;

    public static void main(String[] args) throws Exception {
        SHARPXMI.EvaluationOptions options = (SHARPXMI.EvaluationOptions)CliFactory.parseArguments(SHARPXMI.EvaluationOptions.class, (String[])args);
        SHARPXMI.validate(options);
        SHARPXMI.generateXMI(options);
        ArrayList gridOfSettings = Lists.newArrayList();
        for (int solver : new int[]{0, 1}) {
            for (double svmCost : new double[]{0.01, 0.05, 0.1, 0.5, 1.0, 5.0, 10.0, 50.0, 100.0}) {
                gridOfSettings.add(new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new String[]{"-s", String.valueOf(solver), "-c", String.valueOf(svmCost)}));
            }
        }
        SHARPXMI.evaluate(options, BEST_PARAMETERS, gridOfSettings, new Function<ParameterSettings, ModifierExtractorEvaluation>(){

            public ModifierExtractorEvaluation apply(@Nullable ParameterSettings params) {
                return new ModifierExtractorEvaluation(new File("target/models/modifier"), params);
            }
        });
    }

    public ModifierExtractorEvaluation(File directory, ParameterSettings parameterSettings) {
        super(directory);
        this.parameterSettings = parameterSettings;
    }

    public void train(CollectionReader collectionReader, File directory) throws Exception {
        System.err.printf("%s: %s:\n", ((Object)((Object)this)).getClass().getSimpleName(), directory.getName());
        System.err.println(this.parameterSettings);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{AnalysisEngineFactory.createEngineDescription(OnlyGoldModifiers.class, (Object[])new Object[0]), ModifierExtractorAnnotator.getDescription("dataWriterClassName", this.parameterSettings.dataWriterClass, "outputDirectory", directory.getPath())});
        JarClassifierBuilder.trainAndPackage((File)directory, (String[])this.parameterSettings.trainingArguments);
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AnalysisEngine classifierAnnotator = AnalysisEngineFactory.createEngine((AnalysisEngineDescription)ModifierExtractorAnnotator.getDescription("classifierJarPath", JarClassifierBuilder.getModelJarFile((File)directory)), (Object[])new Object[0]);
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{classifierAnnotator});
        while (casIter.hasNext()) {
            JCas goldView;
            JCas jCas = (JCas)casIter.next();
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            Collection goldModifiers = JCasUtil.select((JCas)goldView, Modifier.class);
            Collection systemModifiers = JCasUtil.select((JCas)jCas, Modifier.class);
            stats.add(goldModifiers, systemModifiers);
        }
        System.err.print(stats);
        System.err.println();
        return stats;
    }

    public static class OnlyGoldModifiers
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Modifier modifier : JCasUtil.select((JCas)jCas, Modifier.class)) {
                modifier.removeFromIndexes();
            }
            for (Modifier goldModifier : JCasUtil.select((JCas)goldView, Modifier.class)) {
                Modifier modifier = new Modifier(jCas, goldModifier.getBegin(), goldModifier.getEnd());
                modifier.setTypeID(goldModifier.getTypeID());
                modifier.setId(goldModifier.getId());
                modifier.setDiscoveryTechnique(goldModifier.getDiscoveryTechnique());
                modifier.setConfidence(goldModifier.getConfidence());
                modifier.addToIndexes();
            }
        }
    }
}

