/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.metastasis;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.ctakes.relationextractor.eval.SHARPXMI;
import org.apache.ctakes.relationextractor.metastasis.MetastasisAnaforaXMLReader;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLSerializer;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MetastasisXmiGenerationPipeline {
    public static final File ANAFORA_ANNOTATIONS_DIR = new File("\\\\rc-fs.tch.harvard.edu\\chip-nlp\\Public\\DeepPhe\\Metastasis\\Anafora\\Test");
    public static final String XMI_OUTPUT_DIR = "C:\\Spiffy\\prj_darth_phenome\\output\\temp\\metastatic\\Test";
    public static final String GOLD_VIEW_NAME = "GoldView";

    public static void main(String[] args) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (File anaforaNoteDir : ANAFORA_ANNOTATIONS_DIR.listFiles()) {
            String noteFileName = anaforaNoteDir.getName();
            String noteFullPath = anaforaNoteDir.getAbsolutePath() + "/" + noteFileName;
            files.add(new File(noteFullPath));
        }
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(files);
        AnalysisEngine engine = MetastasisXmiGenerationPipeline.getXMIWritingPreprocessorAggregateBuilder().createAggregate();
        SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{engine});
    }

    protected static AggregateBuilder getXMIWritingPreprocessorAggregateBuilder() throws Exception {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        File preprocessDescFile = new File("C:\\Spiffy\\ctakes_trunk_intellij\\dev\\apache\\ctakes-relation-extractor\\desc\\analysis_engine/RelationExtractorPreprocessor.xml");
        XMLParser parser = UIMAFramework.getXMLParser();
        XMLInputSource source = new XMLInputSource(preprocessDescFile);
        builder.add(parser.parseAnalysisEngineDescription(source), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", GOLD_VIEW_NAME}), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(SHARPXMI.CopyDocumentTextToGoldView.class, (Object[])new Object[0]), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(SHARPXMI.DocumentIDAnnotator.class, (Object[])new Object[0]), new String[]{"_InitialView", GOLD_VIEW_NAME});
        builder.add(MetastasisAnaforaXMLReader.getDescription(), new String[]{"_InitialView", GOLD_VIEW_NAME});
        builder.add(AnalysisEngineFactory.createEngineDescription(XMIWriter.class, (Object[])new Object[]{"XMIDirectory", XMI_OUTPUT_DIR}), new String[0]);
        return builder;
    }

    static File getXMIFile(File xmiDirectory, JCas jCas) throws AnalysisEngineProcessException {
        return MetastasisXmiGenerationPipeline.getXMIFile(xmiDirectory, new File(ViewUriUtil.getURI((JCas)jCas).getPath()));
    }

    static File getXMIFile(File xmiDirectory, File textFile) {
        return new File(xmiDirectory, textFile.getName() + ".xmi");
    }

    public static class XMIWriter
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_XMI_DIRECTORY = "XMIDirectory";
        @ConfigurationParameter(name="XMIDirectory", mandatory=true)
        private File xmiDirectory;

        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            if (!this.xmiDirectory.exists()) {
                this.xmiDirectory.mkdirs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            File xmiFile = MetastasisXmiGenerationPipeline.getXMIFile(this.xmiDirectory, jCas);
            try (FileOutputStream outputStream = new FileOutputStream(xmiFile);){
                XmiCasSerializer serializer = new XmiCasSerializer(jCas.getTypeSystem());
                ContentHandler handler = new XMLSerializer((OutputStream)outputStream, false).getContentHandler();
                serializer.serialize(jCas.getCas(), handler);
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static class UriToDocumentTextAnnotatorCtakes
    extends UriToDocumentTextAnnotator {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            URI uri = ViewUriUtil.getURI((JCas)jCas);
            try {
                String content = CharStreams.toString((Readable)new InputStreamReader(uri.toURL().openStream()));
                content = content.replace('\f', ' ');
                jCas.setSofaDataString(content, "text/plain");
            }
            catch (MalformedURLException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }
}

