/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.pipelines;

import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class RelationExtractorConsumer
extends JCasAnnotator_ImplBase {
    public final boolean displayEntities = false;
    public final boolean displayContext = false;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas systemView;
        try {
            systemView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        System.out.println();
        for (BinaryTextRelation binaryTextRelation : JCasUtil.select((JCas)systemView, BinaryTextRelation.class)) {
            IdentifiedAnnotation entity2;
            IdentifiedAnnotation entity1;
            String category = binaryTextRelation.getCategory();
            if (binaryTextRelation.getArg1().getRole().equals("Argument")) {
                entity1 = (IdentifiedAnnotation)binaryTextRelation.getArg1().getArgument();
                entity2 = (IdentifiedAnnotation)binaryTextRelation.getArg2().getArgument();
            } else {
                entity1 = (IdentifiedAnnotation)binaryTextRelation.getArg2().getArgument();
                entity2 = (IdentifiedAnnotation)binaryTextRelation.getArg1().getArgument();
            }
            String arg1 = entity1.getCoveredText();
            String arg2 = entity2.getCoveredText();
            int type1 = entity1.getTypeID();
            int type2 = entity2.getTypeID();
            System.out.format("%s(%s/%d, %s/%d)\n", category, arg1, type1, arg2, type2);
        }
    }
}

