/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.model;

import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.util.UTArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;

public class SparseModel
extends AbstractModel {
    public SparseModel() {
    }

    public SparseModel(BufferedReader reader) {
        super(reader);
    }

    @Override
    public void load(BufferedReader reader) {
        System.out.println("Loading model:");
        try {
            this.i_solver = Byte.parseByte(reader.readLine());
            this.loadLabels(reader);
            this.loadFeatures(reader);
            this.loadWeightVector(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    @Override
    public void save(PrintStream fout) {
        System.out.println("Saving model:");
        try {
            fout.println(this.i_solver);
            this.saveLabels(fout);
            this.saveFeatures(fout);
            this.saveWeightVector(fout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    private void loadFeatures(BufferedReader fin) throws IOException {
        this.n_features = Integer.parseInt(fin.readLine());
    }

    private void saveFeatures(PrintStream fout) {
        fout.println(this.n_features);
    }

    public void addFeatures(int[] indices) {
        this.n_features = Math.max(this.n_features, UTArray.max(indices) + 1);
    }
}

