/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.vector;

import com.carrotsearch.hppc.DoubleArrayList;

public abstract class AbstractFeatureVector {
    public static final String DELIM = ":";
    protected DoubleArrayList d_weights;
    protected boolean b_weight;

    public AbstractFeatureVector() {
        this.init();
        this.initWeights(false);
    }

    public AbstractFeatureVector(boolean hasWeight) {
        this.init();
        this.initWeights(hasWeight);
    }

    protected abstract void init();

    private void initWeights(boolean hasWeight) {
        this.d_weights = hasWeight ? new DoubleArrayList() : null;
        this.b_weight = hasWeight;
    }

    public boolean hasWeight() {
        return this.b_weight;
    }

    public double getWeight(int index) {
        return this.d_weights.get(index);
    }

    public double[] getWeights() {
        return this.d_weights.toArray();
    }
}

