/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.component.dep;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.classification.algorithm.AbstractAlgorithm;
import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.component.AbstractStatisticalComponent;
import com.googlecode.clearnlp.dependency.DEPHead;
import com.googlecode.clearnlp.dependency.DEPLabel;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPState;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.map.Prob1DMap;
import com.googlecode.clearnlp.util.pair.ObjectDoublePair;
import com.googlecode.clearnlp.util.pair.Pair;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import com.googlecode.clearnlp.util.triple.Triple;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CDEPBackParser
extends AbstractStatisticalComponent {
    protected final String ENTRY_CONFIGURATION = "dep_back_CONFIGURATION";
    protected final String ENTRY_FEATURE = "dep_back_FEATURE";
    protected final String ENTRY_LEXICA = "dep_back_LEXICA";
    protected final String ENTRY_MODEL = "dep_back_MODEL";
    protected final int LEXICA_PUNCTUATION = 0;
    protected final String LB_LEFT = "L";
    protected final String LB_RIGHT = "R";
    protected final String LB_NO = "N";
    protected final String LB_SHIFT = "S";
    protected final String LB_REDUCE = "R";
    protected final String LB_PASS = "P";
    protected IntOpenHashSet s_reduce;
    protected Prob1DMap p_punc;
    protected Set<String> s_punc;
    protected StringIntPair[] g_heads;
    protected int i_lambda;
    protected int i_beta;
    protected Map<String, Pair<DEPLabel, DEPLabel>> m_labels;
    protected List<List<DEPHead>> l_2nd;
    protected int n_trans;
    protected int n_beams;
    protected double d_score;
    protected double d_margin;
    protected boolean b_first;

    public CDEPBackParser(JointFtrXml[] xmls) {
        super(xmls);
        this.p_punc = new Prob1DMap();
    }

    public CDEPBackParser(JointFtrXml[] xmls, StringTrainSpace[] spaces, Object[] lexica, double margin, int beams) {
        super(xmls, spaces, lexica);
        this.d_margin = margin;
        this.n_beams = beams;
    }

    public CDEPBackParser(JointFtrXml[] xmls, StringModel[] models, Object[] lexica, double margin, int beams) {
        super(xmls, models, lexica);
        this.d_margin = margin;
        this.n_beams = beams;
    }

    public CDEPBackParser(JointFtrXml[] xmls, StringTrainSpace[] spaces, StringModel[] models, Object[] lexica, double margin, int beams) {
        super(xmls, spaces, models, lexica);
        this.d_margin = margin;
        this.n_beams = beams;
    }

    public CDEPBackParser(ZipInputStream in) {
        super(in);
    }

    @Override
    protected void initLexia(Object[] lexica) {
        this.s_punc = (Set)lexica[0];
    }

    @Override
    public void loadModels(ZipInputStream zin) {
        int fLen = "dep_back_FEATURE".length();
        int mLen = "dep_back_MODEL".length();
        this.f_xmls = new JointFtrXml[1];
        this.s_models = null;
        try {
            ZipEntry zEntry;
            while ((zEntry = zin.getNextEntry()) != null) {
                String entry = zEntry.getName();
                if (entry.equals("dep_back_CONFIGURATION")) {
                    this.loadConfiguration(zin);
                    continue;
                }
                if (entry.startsWith("dep_back_FEATURE")) {
                    this.loadFeatureTemplates(zin, Integer.parseInt(entry.substring(fLen)));
                    continue;
                }
                if (entry.startsWith("dep_back_MODEL")) {
                    this.loadStatisticalModels(zin, Integer.parseInt(entry.substring(mLen)));
                    continue;
                }
                if (!entry.equals("dep_back_LEXICA")) continue;
                this.loadLexica(zin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadConfiguration(ZipInputStream zin) throws Exception {
        BufferedReader fin = UTInput.createBufferedReader(zin);
        System.out.println("Loading configuration.");
        this.s_models = new StringModel[Integer.parseInt(fin.readLine())];
        this.n_beams = Integer.parseInt(fin.readLine());
        this.d_margin = Double.parseDouble(fin.readLine());
    }

    protected void loadLexica(ZipInputStream zin) throws Exception {
        BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
        System.out.println("Loading lexica.");
        this.s_punc = UTInput.getStringSet(fin);
    }

    @Override
    public void saveModels(ZipOutputStream zout) {
        try {
            this.saveConfiguration(zout, "dep_back_CONFIGURATION");
            this.saveFeatureTemplates(zout, "dep_back_FEATURE");
            this.saveLexica(zout);
            this.saveStatisticalModels(zout, "dep_back_MODEL");
            zout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveConfiguration(ZipOutputStream zout, String entryName) throws Exception {
        zout.putNextEntry(new ZipEntry(entryName));
        PrintStream fout = UTOutput.createPrintBufferedStream(zout);
        System.out.println("Saving configuration.");
        fout.println(this.s_models.length);
        fout.println(this.n_beams);
        fout.println(this.d_margin);
        fout.flush();
        zout.closeEntry();
    }

    protected void saveLexica(ZipOutputStream zout) throws Exception {
        zout.putNextEntry(new ZipEntry("dep_back_LEXICA"));
        PrintStream fout = UTOutput.createPrintBufferedStream(zout);
        System.out.println("Saving lexica.");
        UTOutput.printSet(fout, this.s_punc);
        fout.flush();
        zout.closeEntry();
    }

    @Override
    public Object[] getLexica() {
        Object[] lexica = new Object[]{this.i_flag == 0 ? this.p_punc.toSet(this.f_xmls[0].getPunctuationCutoff()) : this.s_punc};
        return lexica;
    }

    @Override
    public void countAccuracy(int[] counts) {
        int pos = 0;
        int las = 0;
        int uas = 0;
        int ls = 0;
        for (int i = 1; i < this.t_size; ++i) {
            DEPNode node = this.d_tree.get(i);
            if (node.isPos(node.getFeat("p0"))) {
                ++pos;
            }
            StringIntPair p = this.g_heads[i];
            if (node.isDependentOf(this.d_tree.get(p.i))) {
                ++uas;
                if (node.isLabel(p.s)) {
                    ++las;
                }
            }
            if (!node.isLabel(p.s)) continue;
            ++ls;
        }
        counts[0] = counts[0] + (this.t_size - 1);
        counts[1] = counts[1] + pos;
        counts[2] = counts[2] + las;
        counts[3] = counts[3] + uas;
        counts[4] = counts[4] + ls;
    }

    public void setMargin(double margin) {
        this.d_margin = margin;
    }

    public void setBeams(int beams) {
        this.n_beams = beams;
    }

    @Override
    public void process(DEPTree tree) {
        this.init(tree);
        this.processAux();
    }

    protected void init(DEPTree tree) {
        this.d_tree = tree;
        this.t_size = tree.size();
        this.b_first = true;
        this.m_labels = new HashMap<String, Pair<DEPLabel, DEPLabel>>();
        this.l_2nd = new ArrayList<List<DEPHead>>();
        for (int i = 0; i < this.t_size; ++i) {
            this.l_2nd.add(new ArrayList());
        }
        if (this.i_flag != 2) {
            this.g_heads = tree.getHeads();
            tree.clearHeads();
        }
        this.initAux();
    }

    protected void initAux() {
        this.i_lambda = 0;
        this.i_beta = 1;
        this.d_score = 0.0;
        this.n_trans = 0;
        this.s_reduce = new IntOpenHashSet();
    }

    protected void processAux() {
        if (this.i_flag == 0) {
            this.addLexica();
        } else {
            List<Pair<String, StringFeatureVector>> insts = this.parse();
            if (this.i_flag == 1 || this.i_flag == 3) {
                for (Pair<String, StringFeatureVector> inst : insts) {
                    this.s_spaces[0].addInstance((String)inst.o1, (StringFeatureVector)inst.o2);
                }
            }
        }
    }

    private void addLexica() {
        String puncLabel = this.f_xmls[0].getPunctuationLabel();
        for (int i = 1; i < this.t_size; ++i) {
            DEPNode node = this.d_tree.get(i);
            StringIntPair head = this.g_heads[i];
            if (!head.s.equals(puncLabel)) continue;
            this.p_punc.add(node.form);
        }
    }

    protected List<Pair<String, StringFeatureVector>> parse() {
        List insts;
        List list = insts = this.i_flag == 1 ? (List)this.parseMain().o2 : this.parseBranches();
        if (this.i_flag == 2 || this.i_flag == 4) {
            this.postProcess();
        }
        return insts;
    }

    protected Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>> parseMain() {
        ArrayList<Pair<String, StringFeatureVector>> insts = new ArrayList<Pair<String, StringFeatureVector>>();
        List<DEPState> states = new ArrayList<DEPState>();
        while (this.i_beta < this.t_size) {
            if (this.i_lambda < 0) {
                this.noShift();
                continue;
            }
            DEPLabel label = this.getLabel(insts, states);
            this.parseAux(label);
        }
        if (states.size() > this.n_beams - 1) {
            Collections.sort(states);
            states = states.subList(0, this.n_beams - 1);
        }
        return new Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>(this.d_tree.getHeads(), insts, states);
    }

    protected void parseAux(DEPLabel label) {
        DEPNode lambda = this.d_tree.get(this.i_lambda);
        DEPNode beta = this.d_tree.get(this.i_beta);
        this.d_score += label.score;
        ++this.n_trans;
        if (label.isArc("L")) {
            if (this.i_lambda == 0) {
                this.noShift();
            } else if (beta.isDescendentOf(lambda)) {
                this.noPass();
            } else if (label.isList("R")) {
                this.leftReduce(lambda, beta, label.deprel);
            } else {
                this.leftPass(lambda, beta, label.deprel);
            }
        } else if (label.isArc("R")) {
            if (lambda.isDescendentOf(beta)) {
                this.noPass();
            } else if (label.isList("S")) {
                this.rightShift(lambda, beta, label.deprel);
            } else {
                this.rightPass(lambda, beta, label.deprel);
            }
        } else if (label.isList("S")) {
            this.noShift();
        } else if (label.isList("R") && lambda.hasHead()) {
            this.noReduce();
        } else {
            this.noPass();
        }
    }

    protected DEPLabel getLabel(List<Pair<String, StringFeatureVector>> insts, List<DEPState> states) {
        StringFeatureVector vector = this.getFeatureVector(this.f_xmls[0]);
        DEPLabel label = null;
        if (this.i_flag == 1) {
            label = this.getGoldLabel();
            insts.add(new Pair<String, StringFeatureVector>(label.toString(), vector));
        } else if (this.i_flag == 2 || this.i_flag == 4) {
            label = this.getAutoLabel(vector, insts, states);
        } else if (this.i_flag == 3) {
            label = this.getAutoLabel(vector, insts, states);
            insts.add(new Pair<String, StringFeatureVector>(this.getGoldLabel().toString(), vector));
        }
        return label;
    }

    protected DEPLabel getGoldLabel() {
        DEPLabel label = this.getGoldLabelArc();
        label.list = label.isArc("L") ? (this.isGoldReduce(true) ? "R" : "P") : (label.isArc("R") ? (this.isGoldShift() ? "S" : "P") : (this.isGoldShift() ? "S" : (this.isGoldReduce(false) ? "R" : "P")));
        return label;
    }

    private DEPLabel getGoldLabelArc() {
        StringIntPair head = this.g_heads[this.i_lambda];
        if (head.i == this.i_beta) {
            return new DEPLabel("L", head.s);
        }
        head = this.g_heads[this.i_beta];
        if (head.i == this.i_lambda) {
            return new DEPLabel("R", head.s);
        }
        return new DEPLabel("N", "");
    }

    private boolean isGoldShift() {
        if (this.g_heads[this.i_beta].i < this.i_lambda) {
            return false;
        }
        for (int i = this.i_lambda - 1; i > 0; --i) {
            if (this.s_reduce.contains(i) || this.g_heads[i].i != this.i_beta) continue;
            return false;
        }
        return true;
    }

    private boolean isGoldReduce(boolean hasHead) {
        if (!hasHead && !this.d_tree.get(this.i_lambda).hasHead()) {
            return false;
        }
        int size = this.d_tree.size();
        for (int i = this.i_beta + 1; i < size; ++i) {
            if (this.g_heads[i].i != this.i_lambda) continue;
            return false;
        }
        return true;
    }

    private DEPLabel getAutoLabel(StringFeatureVector vector, List<Pair<String, StringFeatureVector>> insts, List<DEPState> states) {
        DEPLabel snd;
        DEPLabel fst;
        String key = vector.toString();
        Pair<DEPLabel, DEPLabel> val = this.m_labels.get(key);
        if (val != null) {
            fst = (DEPLabel)val.o1;
            snd = (DEPLabel)val.o2;
        } else {
            List<StringPrediction> ps = this.s_models[0].predictAll(vector);
            AbstractAlgorithm.normalize(ps);
            fst = new DEPLabel(ps.get((int)0).label, ps.get((int)0).score);
            snd = new DEPLabel(ps.get((int)1).label, ps.get((int)1).score);
            this.m_labels.put(key, new Pair<DEPLabel, DEPLabel>(fst, snd));
        }
        if (fst.score - snd.score < this.d_margin) {
            if (fst.isArc("N")) {
                if (snd.isArc("L")) {
                    List<DEPHead> p = this.l_2nd.get(this.i_lambda);
                    p.add(new DEPHead(this.i_beta, snd.deprel, snd.score));
                } else if (snd.isArc("R")) {
                    List<DEPHead> p = this.l_2nd.get(this.i_beta);
                    p.add(new DEPHead(this.i_lambda, snd.deprel, snd.score));
                }
            }
            if (this.b_first) {
                states.add(new DEPState(this.i_lambda, this.i_beta, this.n_trans, this.d_score, snd, this.d_tree.getHeads(), this.s_reduce.clone()));
            }
        }
        return fst;
    }

    protected void leftReduce(DEPNode lambda, DEPNode beta, String deprel) {
        this.leftArc(lambda, beta, deprel);
        this.reduce();
    }

    protected void leftPass(DEPNode lambda, DEPNode beta, String deprel) {
        this.leftArc(lambda, beta, deprel);
        this.pass();
    }

    protected void rightShift(DEPNode lambda, DEPNode beta, String deprel) {
        this.rightArc(lambda, beta, deprel);
        this.shift();
    }

    protected void rightPass(DEPNode lambda, DEPNode beta, String deprel) {
        this.rightArc(lambda, beta, deprel);
        this.pass();
    }

    protected void noShift() {
        this.shift();
    }

    protected void noReduce() {
        this.reduce();
    }

    protected void noPass() {
        this.pass();
    }

    private void leftArc(DEPNode lambda, DEPNode beta, String deprel) {
        lambda.setHead(beta, deprel);
    }

    private void rightArc(DEPNode lambda, DEPNode beta, String deprel) {
        beta.setHead(lambda, deprel);
    }

    private void shift() {
        this.i_lambda = this.i_beta++;
    }

    private void reduce() {
        this.s_reduce.add(this.i_lambda);
        this.passAux();
    }

    private void pass() {
        this.passAux();
    }

    private void passAux() {
        int i;
        for (i = this.i_lambda - 1; i >= 0; --i) {
            if (this.s_reduce.contains(i)) continue;
            this.i_lambda = i;
            return;
        }
        this.i_lambda = i;
    }

    protected void postProcess() {
        Triple<Object, Object, Double> max = new Triple<Object, Object, Double>(null, null, -1.0);
        DEPNode root = this.d_tree.get(0);
        int size = this.d_tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = this.d_tree.get(i);
            if (node.hasHead()) continue;
            List<DEPHead> list = this.l_2nd.get(node.id);
            if (!list.isEmpty()) {
                for (DEPHead p : list) {
                    DEPNode head = this.d_tree.get(p.headId);
                    if (head.isDescendentOf(node)) continue;
                    node.setHead(head, p.deprel);
                    break;
                }
            }
            if (node.hasHead()) continue;
            max.set(root, "root", -1.0);
            this.postProcessAux(node, -1, max);
            this.postProcessAux(node, 1, max);
            node.setHead((DEPNode)max.o1, (String)max.o2);
        }
    }

    protected void postProcessAux(DEPNode node, int dir, Triple<DEPNode, String, Double> max) {
        int size = this.d_tree.size();
        if (dir < 0) {
            this.i_beta = node.id;
        } else {
            this.i_lambda = node.id;
        }
        block0: for (int i = node.id + dir; 0 <= i && i < size; i += dir) {
            DEPNode head = this.d_tree.get(i);
            if (head.isDescendentOf(node)) continue;
            if (dir < 0) {
                this.i_lambda = i;
            } else {
                this.i_beta = i;
            }
            StringFeatureVector vector = this.getFeatureVector(this.f_xmls[0]);
            List<StringPrediction> ps = this.s_models[0].predictAll(vector);
            AbstractAlgorithm.normalize(ps);
            for (StringPrediction p : ps) {
                if (p.score <= (Double)max.o3) continue block0;
                if ((dir >= 0 || !p.label.startsWith("R")) && (dir <= 0 || !p.label.startsWith("L"))) continue;
                max.set(head, new DEPLabel((String)p.label).deprel, p.score);
                continue block0;
            }
        }
    }

    @Override
    protected String getField(FtrToken token) {
        DEPNode node = this.getNode(token);
        if (node == null) {
            return null;
        }
        if (token.isField("f")) {
            return node.form;
        }
        if (token.isField("m")) {
            return node.lemma;
        }
        if (token.isField("p")) {
            return node.pos;
        }
        if (token.isField("d")) {
            return node.getLabel();
        }
        if (token.isField("n")) {
            int dist = this.i_beta - this.i_lambda;
            return dist > 6 ? "6" : Integer.toString(dist);
        }
        if (token.isField("lv")) {
            return Integer.toString(this.d_tree.getLeftValency(node.id));
        }
        if (token.isField("rv")) {
            return Integer.toString(this.d_tree.getRightValency(node.id));
        }
        if (token.isField("lnpl")) {
            return this.getLeftNearestPunctuation(0, this.i_lambda);
        }
        if (token.isField("rnpl")) {
            return this.getRightNearestPunctuation(this.i_lambda, this.i_beta);
        }
        if (token.isField("lnpb")) {
            return this.getLeftNearestPunctuation(this.i_lambda, this.i_beta);
        }
        if (token.isField("rnpb")) {
            return this.getRightNearestPunctuation(this.i_beta, this.d_tree.size());
        }
        Matcher m = JointFtrXml.P_BOOLEAN.matcher(token.field);
        if (m.find()) {
            int field = Integer.parseInt(m.group(1));
            switch (field) {
                case 0: {
                    return this.i_lambda == 1 ? token.field : null;
                }
                case 1: {
                    return this.i_beta == this.t_size - 1 ? token.field : null;
                }
                case 2: {
                    return this.i_lambda + 1 == this.i_beta ? token.field : null;
                }
                case 3: {
                    return this.s_punc.contains(node.form) ? token.field : null;
                }
            }
            throw new IllegalArgumentException("Unsupported feature: " + field);
        }
        m = JointFtrXml.P_FEAT.matcher(token.field);
        if (m.find()) {
            return node.getFeat(m.group(1));
        }
        return null;
    }

    @Override
    protected String[] getFields(FtrToken token) {
        return null;
    }

    private String getLeftNearestPunctuation(int lIdx, int rIdx) {
        for (int i = rIdx - 1; i > lIdx; --i) {
            String form = this.d_tree.get((int)i).form;
            if (!this.s_punc.contains(form)) continue;
            return form;
        }
        return null;
    }

    private String getRightNearestPunctuation(int lIdx, int rIdx) {
        for (int i = lIdx + 1; i < rIdx; ++i) {
            String form = this.d_tree.get((int)i).form;
            if (!this.s_punc.contains(form)) continue;
            return form;
        }
        return null;
    }

    private DEPNode getNode(FtrToken token) {
        DEPNode node = null;
        switch (token.source) {
            case 's': {
                node = this.getNodeStack(token);
                break;
            }
            case 'l': {
                node = this.getNodeLambda(token);
                break;
            }
            case 'b': {
                node = this.getNodeBeta(token);
            }
        }
        if (node == null) {
            return null;
        }
        if (token.relation != null) {
            if (token.isRelation("h")) {
                node = node.getHead();
            } else if (token.isRelation("h2")) {
                node = node.getGrandHead();
            } else if (token.isRelation("lmd")) {
                node = this.d_tree.getLeftMostDependent(node.id);
            } else if (token.isRelation("rmd")) {
                node = this.d_tree.getRightMostDependent(node.id);
            } else if (token.isRelation("lmd2")) {
                node = this.d_tree.getLeftMostDependent(node.id, 1);
            } else if (token.isRelation("rmd2")) {
                node = this.d_tree.getRightMostDependent(node.id, 1);
            } else if (token.isRelation("lns")) {
                node = this.d_tree.getLeftNearestSibling(node.id);
            } else if (token.isRelation("rns")) {
                node = this.d_tree.getRightNearestSibling(node.id);
            }
        }
        return node;
    }

    private DEPNode getNodeStack(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_lambda);
        }
        int offset = Math.abs(token.offset);
        int dir = token.offset < 0 ? -1 : 1;
        for (int i = this.i_lambda + dir; 0 < i && i < this.i_beta; i += dir) {
            if (this.s_reduce.contains(i) || --offset != 0) continue;
            return this.d_tree.get(i);
        }
        return null;
    }

    private DEPNode getNodeLambda(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_lambda);
        }
        int cIndex = this.i_lambda + token.offset;
        if (0 < cIndex && cIndex < this.i_beta) {
            return this.d_tree.get(cIndex);
        }
        return null;
    }

    private DEPNode getNodeBeta(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_beta);
        }
        int cIndex = this.i_beta + token.offset;
        if (this.i_lambda < cIndex && cIndex < this.t_size) {
            return this.d_tree.get(cIndex);
        }
        return null;
    }

    public List<Pair<String, StringFeatureVector>> parseBranches() {
        Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>> t0 = this.parseMain();
        if ((this.i_flag == 2 || this.i_flag == 4) && ((List)t0.o3).isEmpty()) {
            return null;
        }
        double s0 = this.d_score / (double)this.n_trans;
        this.b_first = false;
        ArrayList<ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>>> list = new ArrayList<ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>>>();
        list.add(new ObjectDoublePair(t0, s0));
        this.backTrackDEP(list, (List)t0.o3);
        if (this.i_flag == 2 || this.i_flag == 4) {
            Triple tm = (Triple)this.getMax(list).o;
            this.d_tree.resetHeads((StringIntPair[])tm.o1);
            return null;
        }
        ArrayList<Pair<String, StringFeatureVector>> insts = new ArrayList<Pair<String, StringFeatureVector>>((Collection)t0.o2);
        this.setGoldScores(list);
        Triple tm = (Triple)this.getMax(list).o;
        insts.addAll((Collection)tm.o2);
        return insts;
    }

    private void backTrackDEP(List<ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>>> list, List<DEPState> states) {
        for (DEPState state : states) {
            this.resetState(state);
            Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>> t1 = this.parseMain();
            double s1 = this.d_score / (double)this.n_trans;
            list.add(new ObjectDoublePair(t1, s1));
        }
    }

    private void resetState(DEPState state) {
        this.i_lambda = state.lambda;
        this.i_beta = state.beta;
        this.n_trans = state.trans;
        this.d_score = state.score;
        this.s_reduce = state.reduce;
        this.d_tree.resetHeads(state.heads);
        this.parseAux(state.label);
    }

    private ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>> getMax(List<ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>>> dList) {
        ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>> max = dList.get(0);
        int size = dList.size();
        for (int i = 1; i < size; ++i) {
            ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>> t = dList.get(i);
            if (!(max.d < t.d)) continue;
            max = t;
        }
        return max;
    }

    private void setGoldScores(List<ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>>> list) {
        for (ObjectDoublePair<Triple<StringIntPair[], List<Pair<String, StringFeatureVector>>, List<DEPState>>> p : list) {
            StringIntPair[] sHeads = (StringIntPair[])((Triple)p.o).o1;
            int c = 0;
            for (int i = 1; i < this.t_size; ++i) {
                StringIntPair gHead = this.g_heads[i];
                StringIntPair sHead = sHeads[i];
                if (gHead.i != sHead.i || !gHead.s.equals(sHead.s)) continue;
                ++c;
            }
            p.d = c;
        }
    }
}

