/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.component.morph;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.morphology.MPLib;
import com.googlecode.clearnlp.morphology.MPLibEn;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CEnglishMPAnalyzer
extends AbstractComponent {
    public final String FIELD_DELIM = "_";
    final String LANG_DIR = "en/";
    final String NOUN_EXC = "en/noun.exc";
    final String VERB_EXC = "en/verb.exc";
    final String ADJ_EXC = "en/adj.exc";
    final String ADV_EXC = "en/adv.exc";
    final String NOUN_BASE = "en/noun.txt";
    final String VERB_BASE = "en/verb.txt";
    final String ADJ_BASE = "en/adj.txt";
    final String ADV_BASE = "en/adv.txt";
    final String ORD_BASE = "en/ordinal.txt";
    final String CRD_BASE = "en/cardinal.txt";
    final String NOUN_RULE = "en/noun.rule";
    final String VERB_RULE = "en/verb.rule";
    final String ADJ_RULE = "en/adj.rule";
    final String ABBR_RULE = "en/abbr.rule";
    final String POS_NOUN = "N";
    final String POS_VERB = "V";
    final String POS_ADJ = "J";
    final String POS_ADV = "R";
    Map<String, String> m_noun_exc;
    Map<String, String> m_verb_exc;
    Map<String, String> m_adj_exc;
    Map<String, String> m_adv_exc;
    Set<String> s_noun_base;
    Set<String> s_verb_base;
    Set<String> s_adj_base;
    Set<String> s_adv_base;
    Set<String> s_ord_base;
    Set<String> s_crd_base;
    List<Pair<String, String>> a_noun_rule;
    List<Pair<String, String>> a_verb_rule;
    List<Pair<String, String>> a_adj_rule;
    Map<String, String> m_abbr_rule;

    public CEnglishMPAnalyzer(ZipInputStream inputStream) throws IOException {
        try {
            this.init(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(ZipInputStream zin) throws IOException {
        ZipEntry zEntry;
        while ((zEntry = zin.getNextEntry()) != null) {
            String filename = zEntry.getName();
            if (filename.equals("en/noun.exc")) {
                this.m_noun_exc = this.getExcecptionMap(zin);
                continue;
            }
            if (filename.equals("en/verb.exc")) {
                this.m_verb_exc = this.getExcecptionMap(zin);
                continue;
            }
            if (filename.equals("en/adj.exc")) {
                this.m_adj_exc = this.getExcecptionMap(zin);
                continue;
            }
            if (filename.equals("en/adv.exc")) {
                this.m_adv_exc = this.getExcecptionMap(zin);
                continue;
            }
            if (filename.equals("en/noun.txt")) {
                this.s_noun_base = this.getBaseSet(zin);
                continue;
            }
            if (filename.equals("en/verb.txt")) {
                this.s_verb_base = this.getBaseSet(zin);
                continue;
            }
            if (filename.equals("en/adj.txt")) {
                this.s_adj_base = this.getBaseSet(zin);
                continue;
            }
            if (filename.equals("en/adv.txt")) {
                this.s_adv_base = this.getBaseSet(zin);
                continue;
            }
            if (filename.equals("en/ordinal.txt")) {
                this.s_ord_base = this.getBaseSet(zin);
                continue;
            }
            if (filename.equals("en/cardinal.txt")) {
                this.s_crd_base = this.getBaseSet(zin);
                continue;
            }
            if (filename.equals("en/noun.rule")) {
                this.a_noun_rule = this.getRuleList(zin);
                continue;
            }
            if (filename.equals("en/verb.rule")) {
                this.a_verb_rule = this.getRuleList(zin);
                continue;
            }
            if (filename.equals("en/adj.rule")) {
                this.a_adj_rule = this.getRuleList(zin);
                continue;
            }
            if (!filename.equals("en/abbr.rule")) continue;
            this.m_abbr_rule = this.getAbbreviationMap(zin);
        }
        zin.close();
    }

    private HashMap<String, String> getExcecptionMap(ZipInputStream zin) throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
        while ((line = fin.readLine()) != null) {
            String base;
            StringTokenizer tok = new StringTokenizer(line);
            String exc = tok.hasMoreTokens() ? tok.nextToken() : null;
            String string = base = tok.hasMoreTokens() ? tok.nextToken() : null;
            if (exc == null || base == null) continue;
            map.put(exc, base);
            while (tok.hasMoreTokens()) {
                map.put(tok.nextToken(), base);
            }
        }
        return map;
    }

    private HashSet<String> getBaseSet(ZipInputStream zin) throws IOException {
        String line;
        HashSet<String> set = new HashSet<String>();
        BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
        while ((line = fin.readLine()) != null) {
            set.add(line.trim());
        }
        return set;
    }

    private ArrayList<Pair<String, String>> getRuleList(ZipInputStream zin) throws IOException {
        String line;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
        while ((line = fin.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line);
            String str0 = tok.nextToken();
            String str1 = tok.hasMoreTokens() ? tok.nextToken() : "";
            list.add(new Pair<String, String>(str0, str1));
        }
        return list;
    }

    private HashMap<String, String> getAbbreviationMap(ZipInputStream zin) throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
        while ((line = fin.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line);
            String abbr = tok.nextToken();
            String pos = tok.nextToken();
            String key = abbr + "_" + pos;
            String base = tok.nextToken();
            map.put(key, base);
        }
        return map;
    }

    @Override
    public void process(DEPTree tree) {
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            node.lemma = this.getLemma(node.form, node.pos);
        }
    }

    public String getLemma(String form, String pos) {
        form = MPLib.normalizeBasic(form);
        return this.getLemmaAux(form.toLowerCase(), pos);
    }

    public Set<String> getPOSTags(String form) {
        HashSet<String> set = new HashSet<String>();
        if (this.m_noun_exc.containsKey(form = form.toLowerCase()) || this.getBaseAux(form, this.s_noun_base, this.a_noun_rule) != null) {
            set.add("N");
        }
        if (this.m_verb_exc.containsKey(form) || this.getBaseAux(form, this.s_verb_base, this.a_verb_rule) != null) {
            set.add("V");
        }
        if (this.m_adj_exc.containsKey(form) || this.getBaseAux(form, this.s_adj_base, this.a_adj_rule) != null) {
            set.add("J");
        }
        if (this.m_adv_exc.containsKey(form)) {
            set.add("R");
        }
        return set;
    }

    private String getLemmaAux(String form, String pos) {
        String morphem = this.getNumber(form, pos);
        if (morphem != null) {
            return morphem;
        }
        morphem = this.getException(form, pos);
        if (morphem != null) {
            return morphem;
        }
        morphem = this.getBase(form, pos);
        if (morphem != null) {
            return morphem;
        }
        morphem = this.getAbbreviation(form, pos);
        if (morphem != null) {
            return morphem;
        }
        return form;
    }

    private String getNumber(String form, String pos) {
        if (pos.equals("CD")) {
            if (this.s_crd_base.contains(form)) {
                return "#crd#";
            }
            if (form.equals("0st") || form.equals("0nd") || form.equals("0rd") || form.equals("0th") || this.s_ord_base.contains(form)) {
                return "#ord#";
            }
        }
        return null;
    }

    private String getException(String form, String pos) {
        if (MPLibEn.isNoun(pos)) {
            return this.m_noun_exc.get(form);
        }
        if (MPLibEn.isVerb(pos)) {
            return this.m_verb_exc.get(form);
        }
        if (MPLibEn.isAdjective(pos)) {
            return this.m_adj_exc.get(form);
        }
        if (MPLibEn.isAdverb(pos)) {
            return this.m_adv_exc.get(form);
        }
        return null;
    }

    private String getBase(String form, String pos) {
        if (MPLibEn.isNoun(pos)) {
            return this.getBaseAux(form, this.s_noun_base, this.a_noun_rule);
        }
        if (MPLibEn.isVerb(pos)) {
            return this.getBaseAux(form, this.s_verb_base, this.a_verb_rule);
        }
        if (MPLibEn.isAdjective(pos)) {
            return this.getBaseAux(form, this.s_adj_base, this.a_adj_rule);
        }
        return null;
    }

    private String getBaseAux(String form, Set<String> set, List<Pair<String, String>> rule) {
        for (Pair<String, String> tup : rule) {
            int offset;
            String base;
            if (!form.endsWith((String)tup.o1) || !set.contains(base = form.substring(0, offset = form.length() - ((String)tup.o1).length()) + (String)tup.o2)) continue;
            return base;
        }
        return null;
    }

    private String getAbbreviation(String form, String pos) {
        String key = form + "_" + pos;
        return this.m_abbr_rule.get(key);
    }
}

