/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;

public class DemoDEPParserMulti {
    final String language = "en";

    public DemoDEPParserMulti(String dictionaryFile, String posModelFile, String depModelFile, String inputDir, int beginIndex, int length) throws Exception {
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer("en", dictionaryFile);
        AbstractSegmenter segmenter = EngineGetter.getSegmenter("en", tokenizer);
        AbstractMPAnalyzer analyzer = EngineGetter.getMPAnalyzer("en", dictionaryFile);
        Pair<POSTagger[], Double> taggers = EngineGetter.getPOSTaggers(posModelFile);
        AbstractDEPParser parser = EngineGetter.getDEPParser(depModelFile);
        String[] inputFiles = UTFile.getSortedFileList(inputDir);
        int endIndex = beginIndex + length;
        if (endIndex > inputFiles.length) {
            endIndex = inputFiles.length;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            String inputFile = inputFiles[i];
            String outputFile = inputFile + ".parsed";
            System.out.println(outputFile);
            this.parse(segmenter, analyzer, taggers, parser, inputFile, outputFile);
        }
    }

    public void parse(AbstractSegmenter segmenter, AbstractMPAnalyzer analyzer, Pair<POSTagger[], Double> taggers, AbstractDEPParser parser, String inputFile, String outputFile) throws Exception {
        BufferedReader reader = UTInput.createBufferedFileReader(inputFile);
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        for (List<String> tokens : segmenter.getSentences(reader)) {
            DEPTree tree = EngineProcess.getDEPTree(taggers, analyzer, parser, tokens);
            fout.println(tree.toStringDEP() + "\n");
        }
        reader.close();
        fout.close();
    }

    public static void main(String[] args) {
        String dictionaryFile = args[0];
        String posModelFile = args[1];
        String depModelFile = args[2];
        String inputDir = args[3];
        int beginIndex = Integer.parseInt(args[4]);
        int length = Integer.parseInt(args[5]);
        try {
            new DemoDEPParserMulti(dictionaryFile, posModelFile, depModelFile, inputDir, beginIndex, length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

