/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.googlecode.clearnlp.coreference.Mention;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPCountArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.util.pair.IntIntPair;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DEPTree
extends ArrayList<DEPNode> {
    private static final long serialVersionUID = -8007954222948953695L;
    private List<Mention> l_mentions;

    public DEPTree() {
        DEPNode root = new DEPNode();
        root.initRoot();
        this.add(root);
    }

    public void initXHeads() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.get((int)i).x_heads = new ArrayList<DEPArc>();
        }
    }

    public void initSHeads() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.get((int)i).s_heads = new ArrayList<DEPArc>();
        }
    }

    @Override
    public DEPNode get(int id) {
        try {
            return (DEPNode)super.get(id);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getLeftValency(int id) {
        DEPNode node = this.get(id);
        int c = 0;
        for (int i = node.id - 1; i > 0; --i) {
            if (this.get(i).getHead() != node) continue;
            ++c;
        }
        return c;
    }

    public int getRightValency(int id) {
        int c = 0;
        int size = this.size();
        DEPNode node = this.get(id);
        for (int i = node.id + 1; i < size; ++i) {
            if (this.get(i).getHead() != node) continue;
            ++c;
        }
        return c;
    }

    public DEPNode getLeftMostDependent(int id) {
        DEPNode head = this.get(id);
        for (int i = 1; i < id; ++i) {
            DEPNode node = this.get(i);
            if (node.getHead() != head) continue;
            return node;
        }
        return null;
    }

    public DEPNode getLeftMostDependent(int id, int order) {
        DEPNode head = this.get(id);
        for (int i = 1; i < id; ++i) {
            DEPNode node = this.get(i);
            if (node.getHead() != head) continue;
            if (order == 0) {
                return node;
            }
            --order;
        }
        return null;
    }

    public DEPNode getRightMostDependent(int id) {
        DEPNode head = this.get(id);
        for (int i = this.size() - 1; i > id; --i) {
            DEPNode node = this.get(i);
            if (node.getHead() != head) continue;
            return node;
        }
        return null;
    }

    public DEPNode getRightMostDependent(int id, int order) {
        DEPNode head = this.get(id);
        for (int i = this.size() - 1; i > id; --i) {
            DEPNode node = this.get(i);
            if (node.getHead() != head) continue;
            if (order == 0) {
                return node;
            }
            --order;
        }
        return null;
    }

    public DEPNode getLeftNearestSibling(int id) {
        DEPNode head = this.get(id).getHead();
        if (head == null) {
            return null;
        }
        int eIdx = head.id < id ? head.id : 0;
        for (int i = id - 1; i > eIdx; --i) {
            DEPNode node = this.get(i);
            if (node.getHead() != head) continue;
            return node;
        }
        return null;
    }

    public DEPNode getRightNearestSibling(int id) {
        DEPNode head = this.get(id).getHead();
        if (head == null) {
            return null;
        }
        int eIdx = id < head.id ? head.id : this.size();
        for (int i = id + 1; i < eIdx; ++i) {
            DEPNode node = this.get(i);
            if (node.getHead() != head) continue;
            return node;
        }
        return null;
    }

    public DEPNode getNextPredicate(int prevId) {
        int size = this.size();
        for (int i = prevId + 1; i < size; ++i) {
            DEPNode pred = this.get(i);
            if (pred.getFeat("pb") == null) continue;
            return pred;
        }
        return null;
    }

    public boolean containsPredicate() {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            if (this.get(i).getFeat("pb") == null) continue;
            return true;
        }
        return false;
    }

    public void setDependents() {
        int i;
        int size = this.size();
        if (this.get((int)0).l_dependents != null) {
            return;
        }
        for (i = 0; i < size; ++i) {
            this.get((int)i).l_dependents = new ArrayList<DEPArc>();
        }
        for (i = 1; i < size; ++i) {
            DEPNode node = this.get(i);
            DEPNode head = node.getHead();
            if (head == null) continue;
            head.addDependent(node, node.getLabel());
        }
    }

    public List<List<DEPArc>> getArgumentList() {
        int i;
        int size = this.size();
        ArrayList<List<DEPArc>> list = new ArrayList<List<DEPArc>>();
        for (i = 0; i < size; ++i) {
            list.add(new ArrayList());
        }
        for (i = 1; i < size; ++i) {
            DEPNode node = this.get(i);
            for (DEPArc arc : node.getSHeads()) {
                List args = (List)list.get(arc.getNode().id);
                args.add(new DEPArc(node, arc.getLabel()));
            }
        }
        return list;
    }

    public boolean containsCycle() {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = this.get(i);
            if (!node.getHead().isDescendentOf(node)) continue;
            return true;
        }
        return false;
    }

    public List<Mention> getMentions() {
        return this.l_mentions;
    }

    public void setMentions(List<Mention> mentions) {
        this.l_mentions = mentions;
    }

    public void merge(List<StringIntPair[]> lHeads) {
        int size = this.size();
        StringIntPair[] H = new StringIntPair[size];
        ArrayList<DEPCountArc> F = new ArrayList<DEPCountArc>();
        IntOpenHashSet T = new IntOpenHashSet();
        StringIntPair[] t = lHeads.get(0);
        for (int i = 1; i < size; ++i) {
            H[i] = new StringIntPair(t[i].s, t[i].i);
        }
        T.add(0);
        F.addAll(this.getArcs(lHeads, T));
        while (!F.isEmpty()) {
            Collections.sort(F);
            DEPCountArc a = (DEPCountArc)F.get(0);
            H[a.depId].i = a.headId;
            H[a.depId].s = a.deprel;
            T.add(a.depId);
            this.removeArcs(F, a.depId);
            F.addAll(this.getArcs(lHeads, T));
        }
        this.resetHeads(H);
    }

    private List<DEPCountArc> getArcs(List<StringIntPair[]> lHeads, IntOpenHashSet T) {
        HashMap<String, DEPCountArc> map = new HashMap<String, DEPCountArc>();
        int len = this.size();
        int size = lHeads.size();
        for (int i = 0; i < size; ++i) {
            StringIntPair[] heads = lHeads.get(i);
            for (int depId = 1; depId < len; ++depId) {
                StringIntPair head = heads[depId];
                if (head == null || !T.contains(head.i) || T.contains(depId)) continue;
                String key = depId + "_" + head.i + "_" + head.s;
                DEPCountArc val = (DEPCountArc)map.get(key);
                if (val == null) {
                    val = new DEPCountArc(1, i, depId, head.i, head.s);
                    map.put(key, val);
                } else {
                    ++val.count;
                }
                heads[depId] = null;
            }
        }
        return new ArrayList<DEPCountArc>(map.values());
    }

    private void removeArcs(List<DEPCountArc> F, int depId) {
        ArrayList<DEPCountArc> remove = new ArrayList<DEPCountArc>();
        for (DEPCountArc p : F) {
            if (p.depId != depId) continue;
            remove.add(p);
        }
        F.removeAll(remove);
    }

    public void projectivize() {
        DEPNode nonProj;
        IntArrayList ids = new IntArrayList();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            ids.add(i);
        }
        while ((nonProj = this.getSmallestNonProjectiveArc(ids)) != null) {
            nonProj.setHead(nonProj.getHead().getHead(), "#NPRJ!");
        }
    }

    private DEPNode getSmallestNonProjectiveArc(IntArrayList ids) {
        IntOpenHashSet remove = new IntOpenHashSet();
        DEPNode nonProj = null;
        int max = 0;
        for (IntCursor cur : ids) {
            DEPNode wk = this.get(cur.value);
            int np = this.isNonProjective(wk);
            if (np == 0) {
                remove.add(cur.value);
                continue;
            }
            if (np <= max) continue;
            nonProj = wk;
            max = np;
        }
        ids.removeAll((IntLookupContainer)remove);
        return nonProj;
    }

    public int isNonProjective(DEPNode wk) {
        int eId;
        int bId;
        DEPNode wi = wk.getHead();
        if (wi == null) {
            return 0;
        }
        if (wk.id < wi.id) {
            bId = wk.id;
            eId = wi.id;
        } else {
            bId = wi.id;
            eId = wk.id;
        }
        for (int j = bId + 1; j < eId; ++j) {
            DEPNode wj = this.get(j);
            if (wj.isDescendentOf(wi)) continue;
            return Math.abs(wi.id - wk.id);
        }
        return 0;
    }

    public void clearPOSTags() {
        for (DEPNode node : this) {
            node.pos = null;
        }
    }

    public void clearHeads() {
        for (DEPNode node : this) {
            node.d_head.clear();
        }
    }

    public void clearXHeads() {
        for (DEPNode node : this) {
            node.x_heads.clear();
        }
    }

    public void clearSHeads() {
        for (DEPNode node : this) {
            node.s_heads.clear();
        }
    }

    public void clearPredicates() {
        for (DEPNode node : this) {
            node.removeFeat("pb");
        }
    }

    public void resetPOSTags(String[] tags) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            this.get((int)i).pos = tags[i];
        }
    }

    public void resetHeads(StringIntPair[] heads) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = this.get(i);
            StringIntPair head = heads[i];
            if (head.i == -1) {
                node.clearHead();
                continue;
            }
            node.setHead(this.get(head.i), head.s);
        }
    }

    public StringIntPair[] getDiff(StringIntPair[] heads) {
        int size = this.size();
        StringIntPair[] diff = new StringIntPair[size];
        for (int i = 1; i < size; ++i) {
            DEPNode node = this.get(i);
            DEPNode head = node.getHead();
            StringIntPair p = heads[i];
            diff[i] = head != null && head.id != p.i && !node.isLabel(p.s) ? new StringIntPair(node.getLabel(), head.id) : new StringIntPair(null, -1);
        }
        return diff;
    }

    public void appendHeads(StringIntPair[] heads) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            StringIntPair p = heads[i];
            if (p.i == -1) continue;
            this.get(i).setHead(this.get(p.i), p.s);
        }
    }

    public String[] getPOSTags() {
        int size = this.size();
        String[] tags = new String[size];
        for (int i = 1; i < size; ++i) {
            tags[i] = this.get((int)i).pos;
        }
        return tags;
    }

    public StringIntPair[] getHeads() {
        int size = this.size();
        StringIntPair[] heads = new StringIntPair[size];
        heads[0] = new StringIntPair("_R_", -1);
        for (int i = 1; i < size; ++i) {
            DEPArc head = this.get((int)i).d_head;
            heads[i] = head.node != null ? new StringIntPair(head.label, head.getNode().id) : new StringIntPair(null, -1);
        }
        return heads;
    }

    public Boolean[] getPredicates() {
        int size = this.size();
        Boolean[] rolesets = new Boolean[size];
        for (int i = 1; i < size; ++i) {
            rolesets[i] = this.get(i).getFeat("pb") != null;
        }
        return rolesets;
    }

    public String[] getSenses(String key) {
        int size = this.size();
        String[] senses = new String[size];
        for (int i = 1; i < size; ++i) {
            senses[i] = this.get(i).getFeat(key);
        }
        return senses;
    }

    public String[] getRolesetIDs() {
        int size = this.size();
        String[] rolesets = new String[size];
        for (int i = 1; i < size; ++i) {
            rolesets[i] = this.get(i).getFeat("pb");
        }
        return rolesets;
    }

    public StringIntPair[][] getXHeads() {
        return this.getHeadsAux(true);
    }

    public StringIntPair[][] getSHeads() {
        return this.getHeadsAux(false);
    }

    private StringIntPair[][] getHeadsAux(boolean isXhead) {
        int size = this.size();
        StringIntPair[][] xHeads = new StringIntPair[size][];
        xHeads[0] = new StringIntPair[0];
        for (int i = 1; i < size; ++i) {
            List<DEPArc> arcs = isXhead ? this.get(i).getXHeads() : this.get(i).getSHeads();
            int len = arcs.size();
            StringIntPair[] heads = new StringIntPair[len];
            for (int j = 0; j < len; ++j) {
                DEPArc arc = arcs.get(j);
                if (arc.getNode() == null) {
                    System.err.println(i + "\n" + this.toStringDEP());
                }
                heads[j] = new StringIntPair(arc.label, arc.getNode().id);
            }
            xHeads[i] = heads;
        }
        return xHeads;
    }

    @Override
    public String toString() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i));
        }
        return build.substring("\n".length());
    }

    public String toStringRaw() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append(" ");
            build.append(this.get((int)i).form);
        }
        return build.substring(1);
    }

    public String toStringPOS() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i).toStringPOS());
        }
        return build.substring("\n".length());
    }

    public String toStringMorph() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i).toStringMorph());
        }
        return build.substring("\n".length());
    }

    public String toStringDEP() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i).toStringDEP());
        }
        return build.substring("\n".length());
    }

    public String toStringDAG() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i).toStringDAG());
        }
        return build.substring("\n".length());
    }

    public String toStringCoNLL() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i).toStringCoNLL());
        }
        return build.substring("\n".length());
    }

    public String toStringSRL() {
        StringBuilder build = new StringBuilder();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            build.append("\n");
            build.append(this.get(i).toStringSRL());
        }
        return build.substring("\n".length());
    }

    @Deprecated
    public IntOpenHashSet getNonProjectiveSet() {
        IntObjectOpenHashMap map = new IntObjectOpenHashMap();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            int eIdx;
            int bIdx;
            DEPNode curr = this.get(i);
            DEPNode head = curr.getHead();
            if (curr.id < head.id) {
                bIdx = curr.id;
                eIdx = head.id;
            } else {
                bIdx = head.id;
                eIdx = curr.id;
            }
            for (int j = bIdx + 1; j < eIdx; ++j) {
                curr = this.get(j);
                head = curr.getHead();
                if (head.id < bIdx || head.id > eIdx) {
                    this.addNonProjectiveMap((IntObjectOpenHashMap<IntOpenHashSet>)map, i, j);
                    this.addNonProjectiveMap((IntObjectOpenHashMap<IntOpenHashSet>)map, j, i);
                }
                for (DEPArc arc : curr.getDependents()) {
                    DEPNode dep = arc.getNode();
                    if (dep.id >= bIdx && dep.id <= eIdx) continue;
                    this.addNonProjectiveMap((IntObjectOpenHashMap<IntOpenHashSet>)map, i, dep.id);
                    this.addNonProjectiveMap((IntObjectOpenHashMap<IntOpenHashSet>)map, dep.id, i);
                }
            }
        }
        return this.getNonProjectiveMapAux((IntObjectOpenHashMap<IntOpenHashSet>)map);
    }

    @Deprecated
    private void addNonProjectiveMap(IntObjectOpenHashMap<IntOpenHashSet> map, int cIdx, int nIdx) {
        IntOpenHashSet set;
        if (map.containsKey(cIdx)) {
            set = (IntOpenHashSet)map.get(cIdx);
        } else {
            set = new IntOpenHashSet();
            map.put(cIdx, (Object)set);
        }
        set.add(nIdx);
    }

    @Deprecated
    private IntOpenHashSet getNonProjectiveMapAux(IntObjectOpenHashMap<IntOpenHashSet> map) {
        boolean removed;
        IntIntPair max = new IntIntPair(-1, -1);
        do {
            IntOpenHashSet set;
            max.set(-1, -1);
            int[] keys = map.keys().toArray();
            Arrays.sort(keys);
            for (int key : keys) {
                set = (IntOpenHashSet)map.get(key);
                if (set.size() <= max.i2) continue;
                max.set(key, set.size());
            }
            removed = false;
            if (max.i2 <= 0) continue;
            IntOpenHashSet remove = new IntOpenHashSet();
            for (IntCursor cur : (IntOpenHashSet)map.get(max.i1)) {
                if (!map.containsKey(cur.value) || !(set = (IntOpenHashSet)map.get(cur.value)).contains(max.i1)) continue;
                removed = true;
                set.remove(max.i1);
                if (!set.isEmpty()) continue;
                remove.add(cur.value);
            }
            for (IntCursor cur : remove) {
                map.remove(cur.value);
            }
        } while (removed);
        return new IntOpenHashSet((IntContainer)map.keys());
    }
}

