/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency.srl;

import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SRLLib {
    public static final String DELIM_PATH_UP = "^";
    public static final String DELIM_PATH_DOWN = "|";
    public static final String DELIM_SUBCAT = "_";
    private static Pattern P_ARGN = Pattern.compile("^(A|C-A|R-A)\\d");
    private static Pattern P_ARGM = Pattern.compile("^AM");

    public static boolean isNumberedArgument(String label) {
        return P_ARGN.matcher(label).find();
    }

    public static boolean isModifier(String label) {
        return P_ARGM.matcher(label).find();
    }

    public static List<List<DEPArc>> getArgumentList(DEPTree tree) {
        int i;
        int size = tree.size();
        ArrayList<List<DEPArc>> list = new ArrayList<List<DEPArc>>();
        for (i = 0; i < size; ++i) {
            list.add(new ArrayList());
        }
        for (i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            for (DEPArc arc : node.getSHeads()) {
                List args = (List)list.get(arc.getNode().id);
                args.add(new DEPArc(node, arc.getLabel()));
            }
        }
        return list;
    }
}

