/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class CountTransitions {
    final int N = 10;

    public void countTransitions(String inputFile, boolean isSkip) {
        int i;
        DEPTree tree;
        PrintStream fout = UTOutput.createPrintBufferedFileStream("tmp.txt");
        int[] counts = new int[10];
        int[] totals = new int[10];
        DEPReader reader = new DEPReader(0, 1, 2, 3, 4, 5, 6);
        DEPParser parser = new DEPParser(fout);
        int n = 0;
        reader.open(UTInput.createBufferedFileReader(inputFile));
        while ((tree = reader.next()) != null) {
            int index;
            if (isSkip && tree.getNonProjectiveSet().isEmpty()) continue;
            parser.parse(tree);
            ++n;
            int count = parser.getNumTransitions();
            int n2 = index = tree.size() > 101 ? 9 : (tree.size() - 2) / 10;
            counts[n2] = counts[n2] + count;
            int n3 = index;
            totals[n3] = totals[n3] + 1;
        }
        fout.close();
        reader.close();
        System.out.println("# of trees: " + n);
        for (i = 0; i < 9; ++i) {
            System.out.printf("<= %2d: %4.2f (%d/%d)\n", (i + 1) * 10, (double)counts[i] / (double)totals[i], counts[i], totals[i]);
        }
        System.out.printf(" > %2d: %4.2f (%d/%d)\n", i * 10, (double)counts[i] / (double)totals[i], counts[i], totals[i]);
    }

    public void countArguments(String inputFile, boolean isGold) {
        DEPTree tree;
        Pattern isPred = Pattern.compile("NN.*");
        SRLReader reader = isGold ? new SRLReader(0, 1, 2, 4, 6, 7, 9, 12) : new SRLReader(0, 1, 3, 4, 6, 8, 10, 12);
        int[] counts = new int[2];
        int[][] spaces = new int[3][10];
        reader.open(UTInput.createBufferedFileReader(inputFile));
        while ((tree = reader.next()) != null) {
            tree.setDependents();
            this.checkArguments(tree, counts, spaces, isPred);
        }
        System.out.printf("Argument coverage: %5.2f ( %d / %d )\n", 100.0 * (double)counts[0] / (double)counts[1], counts[0], counts[1]);
        int tPred = 0;
        double[] f = new double[spaces.length - 1];
        for (int i = 0; i < 10; ++i) {
            int t = spaces[f.length][i];
            for (int j = 0; j < f.length; ++j) {
                f[j] = (double)spaces[j][i] / (double)t;
            }
            System.out.printf("%3d: %5.2f ( %5d / %5d ) | %5.2f ( %5d / %5d )\n", i, f[0], spaces[0][i], t, f[1], spaces[1][i], t);
            tPred += t;
        }
        System.out.printf("# of predicates: %d\n", tPred);
    }

    private void checkArguments(DEPTree tree, int[] counts, int[][] spaces, Pattern isPred) {
        List<List<DEPArc>> list = tree.getArgumentList();
        int size = tree.size();
        int n = (size - 2) / 10;
        if (n > 9) {
            n = 9;
        }
        for (int i = 1; i < size; ++i) {
            DEPNode pred = tree.get(i);
            if (!isPred.matcher(pred.pos).find()) continue;
            List<DEPArc> args = list.get(i);
            Set<DEPNode> cans = pred.getArgumentCandidateSet(100, false);
            if (pred.getFeat("pb") != null) {
                int[] nArray = spaces[0];
                int n2 = n;
                nArray[n2] = nArray[n2] + (size - 2);
                int[] nArray2 = spaces[1];
                int n3 = n;
                nArray2[n3] = nArray2[n3] + cans.size();
                int[] nArray3 = spaces[2];
                int n4 = n;
                nArray3[n4] = nArray3[n4] + 1;
            }
            if (args.isEmpty()) continue;
            for (DEPArc arc : args) {
                if (!cans.contains(arc.getNode())) continue;
                counts[0] = counts[0] + 1;
            }
            counts[1] = counts[1] + args.size();
        }
    }

    public static void main(String[] args) {
        CountTransitions c = new CountTransitions();
        c.countArguments(args[0], Boolean.parseBoolean(args[1]));
    }
}

