/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.component.pos.CPOSTagger;
import com.googlecode.clearnlp.component.pos.ONPOSTagger;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.nlp.NLPDevelop;
import com.googlecode.clearnlp.reader.JointReader;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTXml;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ONPOSTrain
extends NLPDevelop {
    public ONPOSTrain(String[] args) {
        this.initArgs(args);
        try {
            this.develop(this.s_configFile, this.s_featureFiles.split(":"), this.s_trainDir, this.s_devDir, this.s_mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void develop(String configFile, String[] featureFiles, String trainDir, String devDir, String mode) throws Exception {
        int i;
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configFile));
        JointFtrXml[] xmls = this.getFeatureTemplates(featureFiles);
        String[] trainFiles = UTFile.getSortedFileListBySize(trainDir, ".*", true);
        String[] devFiles = UTFile.getSortedFileListBySize(devDir, ".*", true);
        JointReader reader = this.getJointReader(UTXml.getFirstElementByTagName(eConfig, "reader"));
        CPOSTagger component = new CPOSTagger(xmls, this.getLowerSimplifiedForms(reader, xmls[0], trainFiles, -1));
        Object[] lexica = component != null ? this.getLexica(component, reader, xmls, trainFiles, -1) : null;
        ONPOSTagger tagger = new ONPOSTagger(xmls, lexica, 0.01, 0.1);
        List<DEPTree> trainTrees = this.getTrees(reader, trainFiles);
        List<DEPTree> devTrees = this.getTrees(reader, devFiles);
        int size = trainTrees.size();
        int cut = size / 10;
        double prevScore = -1.0;
        tagger.train(trainTrees, 0, cut);
        for (i = cut; i < size; ++i) {
            tagger.train(trainTrees.get(i));
        }
        double currScore = this.decode(devTrees, tagger);
        while (prevScore < currScore) {
            prevScore = currScore;
            for (i = 0; i < size; ++i) {
                tagger.train(trainTrees.get(i));
            }
            currScore = this.decode(devTrees, tagger);
        }
    }

    protected List<DEPTree> getTrees(JointReader reader, String[] inputFiles) {
        ArrayList<DEPTree> trees = new ArrayList<DEPTree>();
        for (String inputFile : inputFiles) {
            DEPTree tree;
            reader.open(UTInput.createBufferedFileReader(inputFile));
            while ((tree = reader.next()) != null) {
                trees.add(tree);
            }
            reader.close();
        }
        return trees;
    }

    protected double decode(List<DEPTree> devTrees, ONPOSTagger tagger) {
        int[] counts = this.getCounts("pos");
        for (DEPTree tree : devTrees) {
            tagger.develop(tree);
            tagger.countAccuracy(counts);
            tagger.resetGold();
        }
        return this.getScore("pos", counts);
    }

    public static void main(String[] args) {
        new ONPOSTrain(args);
    }
}

