/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.dependency.srl.SRLEval;
import com.googlecode.clearnlp.dependency.srl.SRLabeler;
import com.googlecode.clearnlp.feature.xml.SRLFtrXml;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.run.SRLTrain;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.IntIntPair;
import com.googlecode.clearnlp.util.pair.Pair;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.FileInputStream;
import java.util.Set;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class SRLDevelop
extends SRLTrain {
    @Option(name="-d", usage="the directory containing development file (input; required)", required=true, metaVar="<filename>")
    private String s_devDir;

    public SRLDevelop() {
    }

    public SRLDevelop(String[] args) {
        this.initArgs(args);
        try {
            this.run(this.s_configXml, this.s_featureXml, this.s_trainDir, this.s_devDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run(String configXml, String featureXml, String trainDir, String devDir) throws Exception {
        double prevScore;
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configXml));
        SRLReader reader = (SRLReader)this.getReader((Element)eConfig).o1;
        SRLFtrXml xml = new SRLFtrXml(new FileInputStream(featureXml));
        String[] trainFiles = UTFile.getSortedFileList(trainDir);
        String[] devFiles = UTFile.getSortedFileList(devDir);
        Pair<Set<String>, Set<String>> p = this.getDownUpSets(reader, xml, trainFiles, -1);
        Pair<Object, Double> model = new Pair<Object, Double>(null, 0.0);
        int i = 0;
        this.develop(eConfig, reader, xml, trainFiles, devFiles, model, (Set)p.o1, (Set)p.o2, i++);
        do {
            prevScore = (Double)model.o2;
            this.develop(eConfig, reader, xml, trainFiles, devFiles, model, (Set)p.o1, (Set)p.o2, i++);
        } while ((Double)model.o2 > prevScore);
    }

    protected void develop(Element eConfig, SRLReader reader, SRLFtrXml xml, String[] trainFiles, String[] devFiles, Pair<StringModel[], Double> model, Set<String> sDown, Set<String> sUp, int boost) throws Exception {
        int i;
        SRLEval gEval = new SRLEval();
        int N = 10;
        int[][] spaces = new int[2][N];
        SRLabeler parser = this.getTrainedLabeler(eConfig, reader, xml, trainFiles, (StringModel[])model.o1, sDown, sUp, -1);
        model.o1 = parser.getModels();
        for (String devFile : devFiles) {
            DEPTree tree;
            reader.open(UTInput.createBufferedFileReader(devFile));
            SRLEval lEval = new SRLEval();
            System.out.println("Predicting: " + devFile);
            i = 0;
            while ((tree = reader.next()) != null) {
                int size;
                int n;
                StringIntPair[][] gHeads = tree.getSHeads();
                parser.label(tree);
                StringIntPair[][] sHeads = tree.getSHeads();
                lEval.evaluate(gHeads, sHeads);
                gEval.evaluate(gHeads, sHeads);
                if (i % 1000 == 0) {
                    System.out.print(".");
                }
                if ((n = ((size = tree.size()) - 2) / N) > N - 1) {
                    n = N - 1;
                }
                IntIntPair p = parser.getNumTransitions();
                int[] nArray = spaces[0];
                int n2 = n;
                nArray[n2] = nArray[n2] + p.i1;
                int[] nArray2 = spaces[1];
                int n3 = n;
                nArray2[n3] = nArray2[n3] + p.i2;
                ++i;
            }
            System.out.println();
            reader.close();
            lEval.printOverall();
        }
        System.out.println("Average");
        gEval.printOverall();
        model.o2 = gEval.getF1("LAS");
        for (i = 0; i < N; ++i) {
            System.out.printf("%3d: %5d %5d\n", i, spaces[0][i], spaces[1][i]);
        }
    }

    public static void main(String[] args) {
        new SRLDevelop(args);
    }
}

