/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.predicate;

import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import com.googlecode.clearnlp.feature.xml.SRLFtrXml;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;

public class PredIdentifier
extends AbstractPredIdentifier {
    private SRLFtrXml f_xml;
    private StringTrainSpace s_space;
    private StringModel s_model;
    private DEPTree d_tree;
    private int i_pred;

    public PredIdentifier(SRLFtrXml xml, StringTrainSpace space) {
        super((byte)1);
        this.f_xml = xml;
        this.s_space = space;
    }

    public PredIdentifier(SRLFtrXml xml, StringModel model) {
        super((byte)2);
        this.f_xml = xml;
        this.s_model = model;
    }

    public PredIdentifier(SRLFtrXml xml, BufferedReader fin) {
        super((byte)2);
        this.f_xml = xml;
        this.s_model = new StringModel(fin);
    }

    public void init(DEPTree tree) {
        this.d_tree = tree;
        tree.setDependents();
        if (this.i_flag == 2) {
            tree.clearPredicates();
        }
    }

    @Override
    public void saveModel(PrintStream fout) {
        this.s_model.save(fout);
    }

    public StringModel getModel() {
        return this.s_model;
    }

    @Override
    public void identify(DEPTree tree) {
        this.init(tree);
        int size = this.d_tree.size();
        this.i_pred = 1;
        while (this.i_pred < size) {
            DEPNode node = tree.get(this.i_pred);
            if (this.f_xml.isPredicate(node)) {
                this.identifyAux(node);
            }
            ++this.i_pred;
        }
    }

    private void identifyAux(DEPNode node) {
        String label;
        StringFeatureVector vector = this.getFeatureVector(this.f_xml);
        if (this.i_flag == 1) {
            String label2 = node.getFeat("pb") == null ? AbstractModel.LABEL_FALSE : AbstractModel.LABEL_TRUE;
            this.s_space.addInstance(label2, vector);
        } else if (this.i_flag == 2 && (label = this.s_model.predictBest((StringFeatureVector)vector).label).equals(AbstractModel.LABEL_TRUE)) {
            node.addFeat("pb", node.lemma + ".XX");
        }
    }

    @Override
    protected String getField(FtrToken token) {
        DEPNode node = this.getNode(token);
        if (node == null) {
            return null;
        }
        if (token.isField("f")) {
            return node.form;
        }
        if (token.isField("m")) {
            return node.lemma;
        }
        if (token.isField("p")) {
            return node.pos;
        }
        if (token.isField("d")) {
            return node.getLabel();
        }
        Matcher m = SRLFtrXml.P_FEAT.matcher(token.field);
        if (m.find()) {
            return node.getFeat(m.group(1));
        }
        return null;
    }

    @Override
    protected String[] getFields(FtrToken token) {
        DEPNode node = this.getNode(token);
        if (node == null) {
            return null;
        }
        if (token.isField("ds")) {
            return this.getDeprelSet(node.getDependents());
        }
        return null;
    }

    private String[] getDeprelSet(List<DEPArc> deps) {
        if (deps.isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (DEPArc arc : deps) {
            set.add(arc.getLabel());
        }
        String[] fields = new String[set.size()];
        set.toArray(fields);
        return fields;
    }

    private DEPNode getNode(FtrToken token) {
        DEPNode node = this.getNodeAux(token);
        if (node == null) {
            return null;
        }
        if (token.relation != null) {
            if (token.isRelation("h")) {
                node = node.getHead();
            } else if (token.isRelation("lmd")) {
                node = node.getLeftMostDependent();
            } else if (token.isRelation("rmd")) {
                node = node.getRightMostDependent();
            }
        }
        return node;
    }

    private DEPNode getNodeAux(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_pred);
        }
        int cIndex = this.i_pred + token.offset;
        if (0 < cIndex && cIndex < this.d_tree.size()) {
            return this.d_tree.get(cIndex);
        }
        return null;
    }
}

